/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup.liquibase.xml;

import com.atlassian.stash.internal.backup.liquibase.xml.XmlEncoder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ObjectArrays;
import com.google.common.primitives.Chars;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class DefaultXmlEncoder
implements XmlEncoder {
    private static final char BACKSLASH = '\\';
    private static final char CARRIAGE_RETURN = '\r';
    private static final char LINE_FEED = '\n';
    private static final char[] ILLEGAL_CHARS = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\u000b', '\f', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\ufffe', '\uffff'};
    private static final char[] EXTRAS = new char[]{'\\', '\r', '\n'};
    private static final char[] MAPPED_CHARS = Chars.concat((char[][])new char[][]{ILLEGAL_CHARS, EXTRAS});
    private static final String[] ENCODINGS;

    @Override
    @Nonnull
    public String decode(@Nonnull String string) {
        StringBuilder buffer = null;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (buffer == null) {
                    buffer = new StringBuilder(string.substring(0, i));
                }
                if (i > len - 2) {
                    throw new RuntimeException("Failed to decode this: \"" + string + "\". Encountered backslash at end of string.");
                }
                if (string.charAt(i + 1) == '\\') {
                    buffer.append('\\');
                    ++i;
                    continue;
                }
                if (i > len - 6) {
                    throw new RuntimeException("Failed to decode this: \"" + string + "\". Malformed Unicode encoding.");
                }
                String codePointString = string.substring(i + 2, i + 6);
                int codePoint = 0;
                try {
                    codePoint = Integer.parseInt(codePointString, 16);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Failed to decode this: \"" + string + "\". Invalid code point.");
                }
                buffer.append((char)codePoint);
                i += 5;
                continue;
            }
            if (buffer == null) continue;
            buffer.append(c);
        }
        return buffer == null ? string : buffer.toString();
    }

    @Override
    @Nonnull
    public String encode(@Nonnull String string) {
        StringBuilder buffer = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int index = Arrays.binarySearch(MAPPED_CHARS, c);
            if (index >= 0 && buffer == null) {
                buffer = new StringBuilder(string.substring(0, i));
            }
            if (buffer == null) continue;
            buffer.append(index < 0 ? Character.valueOf(c) : ENCODINGS[index]);
        }
        return buffer == null ? string : buffer.toString();
    }

    @Override
    @Nonnull
    public String encodeForCdata(@Nonnull String s) {
        String chunk;
        int index;
        Preconditions.checkNotNull((Object)s);
        StringBuilder buffer = new StringBuilder();
        int oldIndex = 0;
        while ((index = s.indexOf("]]>", oldIndex)) > -1) {
            chunk = s.substring(oldIndex, index);
            buffer.append(this.encode(chunk));
            oldIndex = index + 3;
            buffer.append("]]]]><![CDATA[>");
        }
        chunk = s.substring(oldIndex);
        buffer.append(this.encode(chunk));
        return buffer.toString();
    }

    @Override
    public boolean isLegalInXml(char c) {
        return Arrays.binarySearch(ILLEGAL_CHARS, c) < 0;
    }

    static {
        Arrays.sort(MAPPED_CHARS);
        ENCODINGS = (String[])ObjectArrays.newArray(String.class, (int)MAPPED_CHARS.length);
        for (int i = 0; i < MAPPED_CHARS.length; ++i) {
            DefaultXmlEncoder.ENCODINGS[i] = String.format("\\u%04X", MAPPED_CHARS[i]);
        }
        int backslashIndex = Arrays.binarySearch(MAPPED_CHARS, '\\');
        DefaultXmlEncoder.ENCODINGS[backslashIndex] = "\\\\";
    }
}

