/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugin.util.ClassUtils;
import com.atlassian.stash.internal.Dao;
import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public abstract class AbstractHibernateDao<K extends Serializable, E>
implements Dao<K, E> {
    protected static final int DELETE_PAGE_SIZE = 500;
    protected final Class<E> entityClass;
    private final SessionFactory sessionFactory;

    public AbstractHibernateDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.entityClass = (Class)ClassUtils.getTypeArguments(AbstractHibernateDao.class, this.getClass()).get(1);
    }

    public E create(E entity) {
        this.session().saveOrUpdate(entity);
        return entity;
    }

    public void delete(E entity) {
        this.session().delete(entity);
    }

    public void deleteById(K id) {
        this.session().createQuery("delete from " + this.entityClass.getSimpleName() + " where id = :id").setParameter("id", id).executeUpdate();
    }

    @Nonnull
    public Page<E> findAll(PageRequest pageRequest) {
        Criteria criteria = this.session().createCriteria(this.entityClass);
        return this.pageCriteria(this.applyImplicitOrder(criteria), pageRequest);
    }

    @Nonnull
    public Page<E> findAll(PageRequest pageRequest, Predicate<? super E> predicate) {
        Criteria criteria = this.session().createCriteria(this.entityClass);
        return this.pageCriteria(this.applyImplicitOrder(criteria), pageRequest, predicate);
    }

    public E getById(K id) {
        return this.entityClass.cast(this.session().get(this.entityClass, id));
    }

    @Nonnull
    public List<E> getByIds(@Nonnull Collection<K> ids) {
        return this.applyImplicitOrder(this.session().createCriteria(this.entityClass)).add(Restrictions.in((String)"id", ids)).list();
    }

    public E loadById(K id) {
        return this.entityClass.cast(this.session().load(this.entityClass, id));
    }

    public void refresh(E entity) {
        this.session().refresh(entity);
    }

    public E update(E entity) {
        return this.entityClass.cast(this.session().merge(entity));
    }

    protected Criteria applyImplicitOrder(Criteria criteria) {
        for (Order order : this.getImplicitOrder()) {
            criteria.addOrder(order);
        }
        return criteria;
    }

    protected Criteria createCriteria() {
        return this.session().createCriteria(this.entityClass);
    }

    protected abstract Iterable<Order> getImplicitOrder();

    protected boolean isHsql() {
        return ((SessionFactoryImplementor)this.sessionFactory).getDialect() instanceof HSQLDialect;
    }

    protected int maybeBulkDelete(String hql) {
        return this.maybeBulkDelete(hql, Collections.emptyMap());
    }

    protected int maybeBulkDelete(String hql, Map<String, Object> parameters) {
        Session session = this.session();
        if (this.isHsql()) {
            List entities;
            int deleted = 0;
            Query query = this.setParameters(session.createQuery(hql).setMaxResults(500), parameters);
            while (!(entities = query.list()).isEmpty()) {
                for (Object entity : entities) {
                    session.delete(entity);
                    ++deleted;
                }
                session.flush();
                session.clear();
                if (entities.size() >= 500) continue;
                break;
            }
            return deleted;
        }
        return this.setParameters(session.createQuery("delete " + hql), parameters).executeUpdate();
    }

    protected Page<E> pageCriteria(Criteria criteria, PageRequest request, Predicate<? super E> predicate) {
        return HibernatePageUtils.pageCriteria(criteria, request, predicate);
    }

    protected Page<E> pageCriteria(Criteria criteria, PageRequest pageRequest) {
        return HibernatePageUtils.pageCriteria(criteria, pageRequest);
    }

    protected Page<E> pageQuery(Query query, PageRequest request, Predicate<? super E> predicate) {
        return HibernatePageUtils.pageQuery(query, request, predicate);
    }

    protected Page<E> pageQuery(Query query, PageRequest request) {
        return HibernatePageUtils.pageQuery(query, request);
    }

    protected Session session() {
        return this.sessionFactory.getCurrentSession();
    }

    protected Query setParameters(Query query, Map<String, Object> parameters) {
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        return query;
    }
}

