/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

abstract class PermissionCriteria {
    private final Permission permission;
    private final Integer projectId;
    private final Integer repositoryId;

    protected PermissionCriteria(Permission permission, Integer projectId, Integer repositoryId) {
        Preconditions.checkNotNull((Object)permission, (Object)"a permission must be specified");
        Preconditions.checkArgument((!permission.isGlobal() || projectId == null && repositoryId == null ? 1 : 0) != 0, (Object)"a project or repository id can not be specified with a global permission");
        this.permission = permission;
        this.projectId = projectId;
        this.repositoryId = repositoryId;
    }

    public Permission getPermission() {
        return this.permission;
    }

    @Nullable
    public Integer getProjectId() {
        return this.projectId;
    }

    @Nullable
    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    protected static abstract class AbstractBuilder<T> {
        protected Permission permission;
        protected Integer projectId;
        protected Integer repositoryId;

        protected AbstractBuilder() {
        }

        public T permission(Permission permission) {
            this.permission = permission;
            return this.self();
        }

        public T resource(Object resource) {
            if (resource instanceof Repository) {
                Repository repository = (Repository)resource;
                this.repositoryId = repository.getId();
                this.projectId = repository.getProject().getId();
            } else if (resource instanceof Project) {
                Project project = (Project)resource;
                this.projectId = project.getId();
            } else if (resource != null) {
                throw new IllegalArgumentException("Unsupported resource: " + resource);
            }
            return this.self();
        }

        protected abstract T self();
    }
}

