/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestOrder;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.stash.internal.pull.PullRequestParticipantCriteria;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestSearchCriteria {
    private final Set<String> fromRefIds;
    private final Integer fromRepositoryId;
    private final PullRequestOrder order;
    private final Iterable<PullRequestParticipantCriteria> participants;
    private final PullRequestState state;
    private final Set<String> toRefIds;
    private final Integer toRepositoryId;

    private PullRequestSearchCriteria(Builder builder) {
        this.fromRefIds = builder.fromRefIds.build();
        this.fromRepositoryId = builder.fromRepositoryId;
        this.order = builder.order;
        this.participants = builder.participants.build();
        this.state = builder.state;
        this.toRefIds = builder.toRefIds.build();
        this.toRepositoryId = builder.toRepositoryId;
    }

    public Collection<String> getFromRefIds() {
        return this.fromRefIds;
    }

    public Integer getFromRepositoryId() {
        return this.fromRepositoryId;
    }

    public PullRequestOrder getOrder() {
        return this.order;
    }

    public Iterable<PullRequestParticipantCriteria> getParticipants() {
        return this.participants;
    }

    public PullRequestState getState() {
        return this.state;
    }

    public Collection<String> getToRefIds() {
        return this.toRefIds;
    }

    public Integer getToRepositoryId() {
        return this.toRepositoryId;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<String> fromRefIds = ImmutableSet.builder();
        private final ImmutableList.Builder<PullRequestParticipantCriteria> participants = ImmutableList.builder();
        private final ImmutableSet.Builder<String> toRefIds = ImmutableSet.builder();
        private Integer fromRepositoryId;
        private PullRequestOrder order;
        private PullRequestState state;
        private Integer toRepositoryId;

        @Nonnull
        public PullRequestSearchCriteria build() {
            return new PullRequestSearchCriteria(this);
        }

        @Nonnull
        public Builder fromRefIds(@Nullable Iterable<String> values) {
            Builder.addIf(Objects::nonNull, this.fromRefIds, values);
            return this;
        }

        @Nonnull
        public Builder fromRepositoryId(@Nullable Integer value) {
            this.fromRepositoryId = value;
            return this;
        }

        @Nonnull
        public Builder order(@Nullable PullRequestOrder value) {
            this.order = value;
            return this;
        }

        @Nonnull
        public Builder participant(@Nullable PullRequestParticipantCriteria value) {
            Builder.addIf(Objects::nonNull, this.participants, (Object)value);
            return this;
        }

        @Nonnull
        public Builder participants(@Nullable Iterable<PullRequestParticipantCriteria> values) {
            Builder.addIf(Objects::nonNull, this.participants, values);
            return this;
        }

        @Nonnull
        public Builder state(@Nullable PullRequestState value) {
            this.state = value;
            return this;
        }

        @Nonnull
        public Builder toRefIds(@Nullable Iterable<String> values) {
            Builder.addIf(Objects::nonNull, this.toRefIds, values);
            return this;
        }

        @Nonnull
        public Builder toRepositoryId(@Nullable Integer value) {
            this.toRepositoryId = value;
            return this;
        }
    }
}

