/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase;

import com.atlassian.stash.internal.backup.liquibase.LiquibaseDataAccessException;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseUnsupportedDatabaseException;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import liquibase.change.custom.CustomChange;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.core.UnsupportedDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class LiquibaseUtils {
    public static final String CUSTOM_CHANGE_PACKAGE = "com.atlassian.stash.internal.liquibase";
    private static final Function<BeanDefinition, Class<?>> BEAN_DEFINITION_TO_CLASS = new Function<BeanDefinition, Class<?>>(){

        public Class<?> apply(BeanDefinition definition) {
            try {
                return Class.forName(definition.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Bean class was missing from the class path", e);
            }
        }
    };

    private LiquibaseUtils() {
        throw new UnsupportedOperationException("Static utility class - not for instantiation");
    }

    public static Set<Class<?>> findCustomChanges() {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(CustomChange.class));
        return ImmutableSet.copyOf((Collection)Collections2.transform((Collection)provider.findCandidateComponents(CUSTOM_CHANGE_PACKAGE), BEAN_DEFINITION_TO_CLASS));
    }

    public static Connection getConnection(Database database) {
        return ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
    }

    public static Database findDatabase(@Nonnull DataSource dataSource) {
        Preconditions.checkNotNull((Object)dataSource);
        Database database = LiquibaseUtils.findDatabaseForConnection(LiquibaseUtils.getConnection(dataSource));
        if (database instanceof UnsupportedDatabase) {
            throw new LiquibaseUnsupportedDatabaseException(database.getDatabaseProductName());
        }
        return database;
    }

    public static Database findDatabaseForConnection(@Nonnull Connection connection) {
        Preconditions.checkNotNull((Object)connection);
        try {
            return DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
        }
        catch (DatabaseException e) {
            throw new LiquibaseDataAccessException("Failed to find a database implementation", e);
        }
    }

    public static JdbcTemplate getJdbcTemplate(Database database) {
        SingleConnectionDataSource dataSource = new SingleConnectionDataSource(LiquibaseUtils.getConnection(database), true);
        return new JdbcTemplate((DataSource)dataSource);
    }

    private static Connection getConnection(DataSource dataSource) {
        try {
            Connection connection = dataSource.getConnection();
            if (connection == null) {
                throw new IllegalStateException("Data source produced null connection");
            }
            return connection;
        }
        catch (SQLException e) {
            throw new CannotGetJdbcConnectionException("JDBC connection could not be obtained for use by Liquibase DAO", e);
        }
    }
}

