/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.mergecheck;

import com.atlassian.bitbucket.codeinsights.annotation.AnnotationSeverity;
import com.atlassian.bitbucket.scope.Scope;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class SetInsightReportConditionRequest {
    private final AnnotationSeverity minimumProhibitedSeverity;
    private final boolean mustPass;
    private final String reportKey;
    private final Scope scope;

    private SetInsightReportConditionRequest(Builder builder) {
        this.reportKey = builder.reportKey;
        this.scope = builder.scope;
        this.minimumProhibitedSeverity = builder.minimumProhibitedSeverity;
        this.mustPass = builder.mustPass;
    }

    @Nonnull
    public Optional<AnnotationSeverity> getMinimumProhibitedSeverity() {
        return Optional.ofNullable(this.minimumProhibitedSeverity);
    }

    @Nonnull
    public String getReportKey() {
        return this.reportKey;
    }

    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    public boolean isMustPass() {
        return this.mustPass;
    }

    public static class Builder {
        private final String reportKey;
        private final Scope scope;
        private AnnotationSeverity minimumProhibitedSeverity;
        private boolean mustPass;

        public Builder(@Nonnull String reportKey, @Nonnull Scope scope) {
            this.reportKey = Objects.requireNonNull(StringUtils.stripToNull((String)reportKey), "reportKey").toLowerCase(Locale.US);
            this.scope = Objects.requireNonNull(scope, "scope");
        }

        public SetInsightReportConditionRequest build() {
            return new SetInsightReportConditionRequest(this);
        }

        public Builder minimumProhibitedSeverity(@Nullable AnnotationSeverity minimumProhibitedSeverity) {
            this.minimumProhibitedSeverity = minimumProhibitedSeverity;
            return this;
        }

        public Builder mustPass(boolean mustPass) {
            this.mustPass = mustPass;
            return this;
        }
    }
}

