define('bitbucket-plugin-code-insights/internal/report-dialog/report-dialog-detail-container', ['module', 'exports', 'react', 'react-redux', 'reselect', '../state/annotations-by-report-state', './report-dialog'], function (module, exports, _react, _reactRedux, _reselect, _annotationsByReportState, _reportDialog) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var reportKeySelector = function reportKeySelector(state, props) {
        return props.item.key;
    };
    var pullRequestSelector = function pullRequestSelector(state, props) {
        return props.pullRequest;
    };

    var reportDetailMapStateToProps = function reportDetailMapStateToProps() {
        var _selectors = (0, _annotationsByReportState.selectors)({
            pullRequestSelector: pullRequestSelector,
            reportKeySelector: reportKeySelector
        }),
            annotationsForReportSelector = _selectors.annotationsForReportSelector,
            annotationsLoadingForReportSelector = _selectors.annotationsLoadingForReportSelector,
            annotationsErrorsForReportSelector = _selectors.annotationsErrorsForReportSelector,
            annotationsTruncatedForReportSelector = _selectors.annotationsTruncatedForReportSelector;

        return (0, _reselect.createStructuredSelector)({
            annotations: annotationsForReportSelector,
            annotationsLoading: annotationsLoadingForReportSelector,
            annotationsErrors: annotationsErrorsForReportSelector,
            truncated: annotationsTruncatedForReportSelector
        });
    };

    var reportDetailMapDispatchToProps = {
        loadAnnotations: _annotationsByReportState.actionCreators.loadAnnotationsForReport
    };

    var ReportDetailContainer = function (_PureComponent) {
        _inherits(ReportDetailContainer, _PureComponent);

        function ReportDetailContainer() {
            _classCallCheck(this, ReportDetailContainer);

            return _possibleConstructorReturn(this, (ReportDetailContainer.__proto__ || Object.getPrototypeOf(ReportDetailContainer)).apply(this, arguments));
        }

        _createClass(ReportDetailContainer, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                this.maybeLoadAnnotations();
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate() {
                this.maybeLoadAnnotations();
            }
        }, {
            key: 'maybeLoadAnnotations',
            value: function maybeLoadAnnotations() {
                var _props = this.props,
                    pullRequest = _props.pullRequest,
                    report = _props.item,
                    annotations = _props.annotations,
                    annotationsLoading = _props.annotationsLoading,
                    loadAnnotations = _props.loadAnnotations,
                    annotationsErrors = _props.annotationsErrors;


                if (annotations == null && !annotationsLoading && !annotationsErrors) {
                    loadAnnotations({ pullRequest: pullRequest, report: report });
                }
            }
        }, {
            key: 'render',
            value: function render() {
                return _react2.default.createElement(_reportDialog.ReportDetail, this.props);
            }
        }]);

        return ReportDetailContainer;
    }(_react.PureComponent);

    exports.default = (0, _reactRedux.connect)(reportDetailMapStateToProps, reportDetailMapDispatchToProps)(ReportDetailContainer);
    module.exports = exports['default'];
});