define('bitbucket-plugin-code-insights/internal/pull-request-overview/pull-request-overview', ['module', 'exports', 'react', 'react-redux', 'bitbucket/util/events', 'bitbucket/internal/feature/file-content/diff-view-options', 'bitbucket/internal/util/history', '../insight-preferences', '../report-dialog/report-dialog-container', '../store', '../summary-link/summary-link-container'], function (module, exports, _react, _reactRedux, _events, _diffViewOptions, _history, _insightPreferences, _reportDialogContainer, _store, _summaryLinkContainer) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = _interopRequireDefault(_react);

    var _events2 = _interopRequireDefault(_events);

    var _diffViewOptions2 = _interopRequireDefault(_diffViewOptions);

    var _history2 = _interopRequireDefault(_history);

    var _reportDialogContainer2 = _interopRequireDefault(_reportDialogContainer);

    var _store2 = _interopRequireDefault(_store);

    var _summaryLinkContainer2 = _interopRequireDefault(_summaryLinkContainer);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var PullRequestOverview = function (_PureComponent) {
        _inherits(PullRequestOverview, _PureComponent);

        function PullRequestOverview() {
            var _ref;

            var _temp, _this, _ret;

            _classCallCheck(this, PullRequestOverview);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = PullRequestOverview.__proto__ || Object.getPrototypeOf(PullRequestOverview)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
                dialogOpen: false
            }, _this.onClickLink = function () {
                _this.setState({ dialogOpen: true });
            }, _this.onCloseDialog = function () {
                _this.setState({ dialogOpen: false });
            }, _this.onAnnotationLinkClicked = function (e) {
                e.preventDefault();
                (0, _insightPreferences.toggleAnnotationVisibilitySetting)(true);
                // the override needs to be set before the diff starts rendering
                // so the correct kind of diffView is used.
                _events2.default.once('bitbucket.internal.DO_NOT_USE.feature.fileContent.handlerRequested', function (_ref2) {
                    var diffViewOptions = _ref2.diffViewOptions;

                    diffViewOptions.setSoftOverride('diffType', 'unified', false);
                    diffViewOptions.setSoftOverride('ignoreWhitespace', false, false);
                });
                _this.onCloseDialog();
                _history2.default.pushState(null, null, e.currentTarget.href);
            }, _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(PullRequestOverview, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    pullRequest = _props.pullRequest,
                    containerEl = _props.containerEl;


                return _react2.default.createElement(
                    _reactRedux.Provider,
                    { store: _store2.default },
                    _react2.default.createElement(
                        _react.Fragment,
                        null,
                        _react2.default.createElement(_summaryLinkContainer2.default, {
                            pullRequest: pullRequest,
                            onClick: this.onClickLink,
                            containerEl: containerEl,
                            className: 'code-insights-overview'
                        }),
                        this.state.dialogOpen && _react2.default.createElement(_reportDialogContainer2.default, {
                            pullRequest: pullRequest,
                            onClose: this.onCloseDialog,
                            onAnnotationLinkClicked: this.onAnnotationLinkClicked
                        })
                    )
                );
            }
        }]);

        return PullRequestOverview;
    }(_react.PureComponent);

    exports.default = PullRequestOverview;
    module.exports = exports['default'];
});