define('bitbucket-plugin-code-insights/internal/pull-request-diff/pull-request-diff', ['module', 'exports', '@atlassian/aui', 'lodash', 'bitbucket/util/events', 'bitbucket/util/state', 'bitbucket/internal/model/diff-type', './annotation-toggle', './diff-annotations', './insights-toolbar-button-init'], function (module, exports, _aui, _lodash, _events, _state, _diffType, _annotationToggle, _diffAnnotations, _insightsToolbarButtonInit) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _events2 = _interopRequireDefault(_events);

    var _state2 = _interopRequireDefault(_state);

    var _annotationToggle2 = _interopRequireDefault(_annotationToggle);

    var _diffAnnotations2 = _interopRequireDefault(_diffAnnotations);

    var _insightsToolbarButtonInit2 = _interopRequireDefault(_insightsToolbarButtonInit);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function init() {
        _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.fileContent.handlingDiff', onDiffView);
    }

    /**
     * Are annotations available for the current diff?
     * @returns {boolean}
     */
    function annotationsAvailable(fileHandlingContext) {
        var diffType = fileHandlingContext.diffViewOptions.get('diffType');

        return !fileHandlingContext.isExcerpt && (0, _lodash.get)(fileHandlingContext, 'fileChange.commitRange.diffType') === _diffType.EFFECTIVE && diffType === 'unified';
    }

    /**
     * @listens bitbucket.internal.feature.fileContent.handlingDiff
     * @param {TextView} textView - the TextView that allows things to be attached to the diff
     * @param {Object} textViewOpts
     */
    function onDiffView(_ref) {
        var fileHandlingContext = _ref.fileHandlingContext,
            data = _ref.data,
            mainView = _ref.mainView,
            onDestroy = _ref.onDestroy;

        var areAnnotationsAvailable = annotationsAvailable(fileHandlingContext);

        if (!areAnnotationsAvailable) {
            var toggle = new _annotationToggle2.default(false);
            toggle.init();
            onDestroy(toggle.destroy);

            return;
        }

        // The insights button plugin point isn't rendered yet. We have to wait until the end of the
        // file handler cycle, which comes immediately after the toolbar renders.
        _events2.default.once('bitbucket.internal.DO_NOT_USE.feature.fileContent.requestHandled', function () {
            var diffAnnotations = new _diffAnnotations2.default(mainView, fileHandlingContext, data, _state2.default.getPullRequest());
            var toggle = new _annotationToggle2.default(true, diffAnnotations.setVisible);
            var insightsButton = (0, _insightsToolbarButtonInit2.default)(diffAnnotations.setChangedLinesOnly);

            diffAnnotations.on('updateInsightsButton', function (state) {
                return insightsButton.render(state);
            });

            diffAnnotations.init(_annotationToggle2.default.isVisible(), _annotationToggle2.default.isChangedLinesOnly());
            toggle.init();

            onDestroy(function () {
                diffAnnotations.destroy();
                toggle.destroy();
                insightsButton.destroy();
            });
        });
    }

    exports.default = {
        init: init
    };
    module.exports = exports['default'];
});