define('bitbucket-plugin-code-insights/internal/annotations-summary/annotations-summary', ['module', 'exports', '@atlassian/aui', 'prop-types', 'react', '../annotation/annotation'], function (module, exports, _aui, _propTypes, _react, _annotation) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var SeveritySummary = function SeveritySummary(_ref) {
        var severity = _ref.severity,
            amount = _ref.amount;
        return _react2.default.createElement(
            _react.Fragment,
            null,
            _react2.default.createElement(_annotation.SeverityIcon, { severity: severity }),
            amount,
            ' '
        );
    };

    var AnnotationsSummary = function AnnotationsSummary(_ref2) {
        var _annotations$reduce;

        var annotations = _ref2.annotations;

        if (!Array.isArray(annotations) || !annotations.length) {
            return null;
        }

        var severityCountMap = annotations.reduce(function (result, _ref3) {
            var severity = _ref3.severity;

            result[severity]++;

            return result;
        }, (_annotations$reduce = {}, _defineProperty(_annotations$reduce, _annotation.Severity.HIGH, 0), _defineProperty(_annotations$reduce, _annotation.Severity.MEDIUM, 0), _defineProperty(_annotations$reduce, _annotation.Severity.LOW, 0), _annotations$reduce));

        return _react2.default.createElement(
            'div',
            { className: 'annotations-summary' },
            _react2.default.createElement(
                'div',
                { className: 'title' },
                _aui.I18n.getText('bitbucket.codeinsights.annotations')
            ),
            _react2.default.createElement(
                'div',
                { className: 'summary' },
                Object.keys(severityCountMap).map(function (severity) {
                    return _react2.default.createElement(SeveritySummary, {
                        key: severity,
                        severity: severity,
                        amount: severityCountMap[severity]
                    });
                })
            )
        );
    };

    AnnotationsSummary.propTypes = {
        annotations: _propTypes2.default.arrayOf(_propTypes2.default.shape({
            severity: _propTypes2.default.string.isRequired
        }))
    };

    exports.default = AnnotationsSummary;
    module.exports = exports['default'];
});