/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.dao;

import com.atlassian.bitbucket.codeinsights.annotation.AnnotationSeverity;
import com.atlassian.bitbucket.codeinsights.annotation.AnnotationType;
import com.atlassian.bitbucket.internal.codeinsights.annotation.ModifiedFile;
import com.atlassian.bitbucket.internal.codeinsights.dao.AoInsightAnnotation;
import com.atlassian.bitbucket.internal.codeinsights.dao.InternalInsightAnnotation;
import com.atlassian.bitbucket.util.UrlUtils;
import java.net.URI;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PartialAoInsightAnnotation {
    private final AoInsightAnnotation delegate;
    private URI link;
    private boolean outdated;
    private String path;
    private AnnotationSeverity severity;
    private AnnotationType type;

    public PartialAoInsightAnnotation(AoInsightAnnotation delegate) {
        this.delegate = delegate;
    }

    public Optional<String> getExternalId() {
        return Optional.ofNullable(this.delegate.getInternalExternalId());
    }

    public long getId() {
        return this.delegate.getID();
    }

    @Nonnull
    public Optional<URI> getLink() {
        return Optional.ofNullable(this.link);
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public String getReportKey() {
        return this.delegate.getReport().getKey();
    }

    @Nonnull
    public AnnotationSeverity getSeverity() {
        return this.severity;
    }

    @Nonnull
    public Optional<AnnotationType> getType() {
        return Optional.ofNullable(this.type);
    }

    @Nonnull
    public InternalInsightAnnotation initialize(@Nullable ModifiedFile file) {
        if (file == null) {
            return this.initialize();
        }
        this.outdated = file.isOutdated();
        this.path = file.getEffectivePath();
        return this.initializeInternal();
    }

    @Nonnull
    public InternalInsightAnnotation initialize() {
        this.path = this.delegate.getInternalPath();
        return this.initializeInternal();
    }

    public boolean isOutdated() {
        return this.outdated;
    }

    private InternalInsightAnnotation initializeInternal() {
        this.link = UrlUtils.uncheckedCreateURI((String)this.delegate.getInternalLink());
        this.severity = AnnotationSeverity.fromId(this.delegate.getSeverityId()).orElseThrow(() -> new IllegalStateException("Invalid severity ID"));
        if (this.delegate.getTypeId() != null) {
            this.type = AnnotationType.fromId(this.delegate.getTypeId()).orElseThrow(() -> new IllegalArgumentException("Invalid type ID"));
        }
        return this.delegate;
    }
}

