define('bitbucket-plugin-code-insights/internal/state/insight-shared-state', ['exports', 'lodash', 'redux', 'reselect', 'bitbucket/internal/bbui/utils/pull-request-unique-id', 'bitbucket/internal/util/store/reducers', './insight-state-utils'], function (exports, _lodash, _redux, _reselect, _pullRequestUniqueId, _reducers, _insightStateUtils) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.makeReducer = exports.selectors = undefined;

    var _pullRequestUniqueId2 = _interopRequireDefault(_pullRequestUniqueId);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var selectors = exports.selectors = function selectors(pullRequestSelector) {
        // Get the report and annotation state for a given PR
        var prStateSelector = (0, _reselect.createSelector)(pullRequestSelector, function (state) {
            return state.insights;
        }, function (pr, insightState) {
            return insightState[(0, _pullRequestUniqueId2.default)(pr)];
        });

        // pull a hardcoded subtree of state from within the PR
        var getSubtreeSelector = function getSubtreeSelector(subtreePath) {
            return function (state, props) {
                return (0, _lodash.get)(prStateSelector(state, props), subtreePath);
            };
        };

        return {
            // For current PR, return the newest source commit we know about. Our state files use this to ensure
            // they are returning only information for the HEAD of the source branch of the PR.
            sourceCommitSelector: function sourceCommitSelector(state, props) {
                var latestPr = (0, _lodash.get)(prStateSelector(state, props), 'pullRequest');
                if (!latestPr) {
                    return null;
                }
                return (0, _insightStateUtils.getPRSourceCommit)(latestPr);
            },
            // selectors to the state subtrees - other state files use these to find their place in the tree.
            reportStateSelector: getSubtreeSelector('reports'),
            reportRequestsStateSelector: getSubtreeSelector('reportRequests'),
            annotationsByReportStateSelector: getSubtreeSelector('annotations.byReport'),
            annotationRequestsByReportStateSelector: getSubtreeSelector('annotationRequests.byReport'),
            annotationsByPathStateSelector: getSubtreeSelector('annotations.byPath'),
            annotationRequestsByPathStateSelector: getSubtreeSelector('annotationRequests.byPath'),
            fileInfoSelector: getSubtreeSelector('fileInfo')
        };
    };

    // We always include the PR ID to disambiguate each PR.
    // This is unused at the moment, but harmless, and we can store state for multiple PRs in the future.
    var keyByPullRequest = (0, _reducers.keyBy)(function (_ref) {
        var type = _ref.type,
            payload = _ref.payload,
            meta = _ref.meta;

        var pr = (0, _lodash.get)(payload, 'pullRequest') || (0, _lodash.get)(meta, 'originalAction.payload.pullRequest', null);
        return pr && (0, _pullRequestUniqueId2.default)(pr);
    });

    /**
     * This creates an overall reducer for report and annotation state.
     * It takes in sub-reducers as arguments, instead of depending on the other state files directly, to avoid
     * a circular dependency between the various state files (the other state files depend on this one for selectors of their
     * respective state subtrees).
     *
     * @param reportsReducer
     * @param reportRequestsReducer
     * @param annotationsByReportReducer
     * @param annotationRequestsByReportReducer
     * @param annotationsByPathReducer
     * @param annotationRequestsByPathReducer
     * @returns {reducer} - object that can be passed to createActorStore
     */
    var makeReducer = exports.makeReducer = function makeReducer(_ref2) {
        var reportsReducer = _ref2.reportsReducer,
            reportRequestsReducer = _ref2.reportRequestsReducer,
            annotationsByReportReducer = _ref2.annotationsByReportReducer,
            annotationRequestsByReportReducer = _ref2.annotationRequestsByReportReducer,
            annotationsByPathReducer = _ref2.annotationsByPathReducer,
            annotationRequestsByPathReducer = _ref2.annotationRequestsByPathReducer,
            fileInfoByPathReducer = _ref2.fileInfoByPathReducer;
        return {
            insights: keyByPullRequest((0, _redux.combineReducers)({
                // keep track of the latest version of the PR that we know about, so we can pull in new data when needed
                pullRequest: function pullRequest() {
                    var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
                    var _ref3 = arguments[1];
                    var payload = _ref3.payload;

                    if (!payload || !payload.pullRequest) {
                        return state;
                    }
                    if (!state || payload.pullRequest.version > state.version) {
                        return payload.pullRequest;
                    }
                    return state;
                },
                reports: reportsReducer,
                reportRequests: reportRequestsReducer,
                annotations: (0, _redux.combineReducers)({
                    byReport: annotationsByReportReducer,
                    byPath: annotationsByPathReducer
                }),
                annotationRequests: (0, _redux.combineReducers)({
                    byReport: annotationRequestsByReportReducer,
                    byPath: annotationRequestsByPathReducer
                }),
                fileInfo: fileInfoByPathReducer
            }))
        };
    };
});