define('bitbucket-plugin-code-insights/internal/report-custom-data/report-custom-data', ['exports', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/util/locale', 'bitbucket/internal/util/text', 'bitbucket/internal/widget/duration', 'bitbucket/internal/widget/time'], function (exports, _aui, _propTypes, _react, _locale, _text, _duration, _time) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.PercentageDatum = exports.TextDatum = exports.NumberDatum = exports.LinkDatum = exports.DurationDatum = exports.DateDatum = exports.BooleanDatum = undefined;

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _duration2 = _interopRequireDefault(_duration);

    var _time2 = _interopRequireDefault(_time);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
        return typeof obj;
    } : function (obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };

    var lang = (0, _locale.getDocumentLocale)();
    var MAX_SPEC_ALLOWED_SIG_FIGS = 21;

    var numberFormatter = new Intl.NumberFormat(lang, {
        maximumSignificantDigits: MAX_SPEC_ALLOWED_SIG_FIGS
    });
    var percentFormatter = new Intl.NumberFormat(lang, {
        maximumSignificantDigits: 4,
        style: 'percent'
    });
    var percentFormatterFull = new Intl.NumberFormat(lang, {
        maximumSignificantDigits: MAX_SPEC_ALLOWED_SIG_FIGS,
        style: 'percent'
    });

    var MILLIS_PER_SECOND = 1000;

    var typeForTypeof = {
        number: 'NUMBER',
        boolean: 'BOOLEAN',
        string: 'TEXT'
    };
    var getEffectiveType = function getEffectiveType(type, value) {
        return type || typeForTypeof[typeof value === 'undefined' ? 'undefined' : _typeof(value)];
    };

    var datumType = {
        title: _propTypes2.default.string.isRequired,
        type: _propTypes2.default.oneOf(['NUMBER', 'TEXT', 'BOOLEAN', 'PERCENTAGE', 'LINK', 'DURATION', 'DATE', null]),
        value: _propTypes2.default.any.isRequired
    };
    var booleanDatumType = _extends({}, datumType, {
        type: _propTypes2.default.oneOf(['BOOLEAN', null]),
        value: _propTypes2.default.bool.isRequired
    });
    var textDatumType = _extends({}, datumType, {
        type: _propTypes2.default.oneOf(['TEXT', null]),
        value: _propTypes2.default.string.isRequired
    });
    var linkDatumType = _extends({}, datumType, {
        type: _propTypes2.default.oneOf(['LINK']),
        value: _propTypes2.default.shape({
            href: _propTypes2.default.string.isRequired,
            linktext: _propTypes2.default.string.isRequired
        }).isRequired
    });
    var numberDatumType = _extends({}, datumType, {
        type: _propTypes2.default.oneOf(['NUMBER', null]),
        value: _propTypes2.default.number.isRequired
    });
    var dateDatumType = _extends({}, numberDatumType, {
        type: _propTypes2.default.oneOf(['DATE'])
    });
    var durationDatumType = _extends({}, numberDatumType, {
        type: _propTypes2.default.oneOf(['DURATION'])
    });
    var percentageDatumType = _extends({}, numberDatumType, {
        type: _propTypes2.default.oneOf(['PERCENTAGE'])
    });

    var BooleanDatum = exports.BooleanDatum = function BooleanDatum(_ref) {
        var value = _ref.value;
        return value ? _aui.I18n.getText('bitbucket.codeinsights.data.boolean.truthy') : _aui.I18n.getText('bitbucket.codeinsights.data.boolean.falsy');
    };
    BooleanDatum.propTypes = {
        value: booleanDatumType.value
    };

    var DateDatum = exports.DateDatum = function DateDatum(_ref2) {
        var value = _ref2.value;
        return _react2.default.createElement(_time2.default, { unixTime: value * MILLIS_PER_SECOND, type: 'shortAge' });
    };
    DateDatum.propTypes = {
        value: dateDatumType.value
    };

    var DurationDatum = exports.DurationDatum = function DurationDatum(_ref3) {
        var value = _ref3.value;
        return _react2.default.createElement(_duration2.default, { durationMillis: value });
    };
    DurationDatum.propTypes = {
        value: durationDatumType.value
    };

    var LinkDatum = exports.LinkDatum = function LinkDatum(_ref4) {
        var _ref4$value = _ref4.value,
            href = _ref4$value.href,
            linktext = _ref4$value.linktext;
        return _react2.default.createElement(
            'a',
            { href: href, target: '_blank', rel: 'noopener noreferrer' },
            linktext
        );
    };
    LinkDatum.propTypes = {
        value: linkDatumType.value
    };

    var NumberDatum = exports.NumberDatum = function NumberDatum(_ref5) {
        var value = _ref5.value;
        return _react2.default.createElement(
            'span',
            { title: numberFormatter.format(value) },
            (0, _text.formatNumberShorthand)(value)
        );
    };
    NumberDatum.propTypes = {
        value: numberDatumType.value
    };

    var TextDatum = exports.TextDatum = function TextDatum(_ref6) {
        var value = _ref6.value;
        return value;
    };
    TextDatum.propTypes = {
        value: textDatumType.value
    };

    var PercentageDatum = exports.PercentageDatum = function PercentageDatum(_ref7) {
        var value = _ref7.value;

        var asFraction = value / 100;
        return _react2.default.createElement(
            'span',
            { title: percentFormatterFull.format(asFraction) },
            percentFormatter.format(asFraction)
        );
    };
    PercentageDatum.propTypes = {
        value: percentageDatumType.value
    };

    var componentForType = {
        BOOLEAN: BooleanDatum,
        DATE: DateDatum,
        DURATION: DurationDatum,
        LINK: LinkDatum,
        NUMBER: NumberDatum,
        PERCENTAGE: PercentageDatum,
        TEXT: TextDatum
    };

    var ReportCustomDatum = function ReportCustomDatum(_ref8) {
        var title = _ref8.title,
            type = _ref8.type,
            value = _ref8.value;

        var Component = componentForType[getEffectiveType(type, value)];
        return _react2.default.createElement(
            _react.Fragment,
            null,
            _react2.default.createElement(
                'dt',
                { title: title },
                title
            ),
            _react2.default.createElement(
                'dd',
                null,
                _react2.default.createElement(Component, { value: value })
            )
        );
    };

    var ReportCustomData = function ReportCustomData(_ref9) {
        var data = _ref9.data;
        return !data ? null : _react2.default.createElement(
            'dl',
            { className: 'report-custom-data' },
            data.map(function (datum) {
                return _react2.default.createElement(ReportCustomDatum, _extends({ key: datum.title }, datum));
            })
        );
    };
    ReportCustomData.propTypes = {
        data: _propTypes2.default.arrayOf(_propTypes2.default.oneOfType([_propTypes2.default.shape(booleanDatumType), _propTypes2.default.shape(dateDatumType), _propTypes2.default.shape(durationDatumType), _propTypes2.default.shape(linkDatumType), _propTypes2.default.shape(numberDatumType), _propTypes2.default.shape(percentageDatumType), _propTypes2.default.shape(textDatumType)]))
    };

    exports.default = ReportCustomData;
});