define('bitbucket-plugin-code-insights/internal/pull-request-diff/annotation-toggle', ['module', 'exports', '@atlassian/aui', 'jquery', 'bitbucket/internal/model/diff-type', 'bitbucket/internal/util/shortcuts', '../insight-preferences'], function (module, exports, _aui, _jquery, _diffType, _shortcuts, _insightPreferences) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var _shortcuts2 = _interopRequireDefault(_shortcuts);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    var ANNOTATIONS_TOGGLE_SELECTOR = '.code-insights-annotations-toggle';

    _shortcuts2.default.bind('requestToggleAnnotations', function () {
        return (0, _jquery2.default)(ANNOTATIONS_TOGGLE_SELECTOR).trigger('click');
    });

    var AnnotationToggle = function () {
        _createClass(AnnotationToggle, null, [{
            key: 'isVisible',
            value: function isVisible() {
                return (0, _insightPreferences.getAnnotationVisibilitySetting)();
            }
        }]);

        function AnnotationToggle(areAnnotationsAvailable, onChange) {
            var _this = this;

            _classCallCheck(this, AnnotationToggle);

            this.init = function () {
                var $doc = (0, _jquery2.default)(document);
                $doc.one('aui-dropdown2-show', '#diff-options-dropdown', _this.onFirstOpen);

                if (_this.areAnnotationsAvailable) {
                    $doc.on('click', ANNOTATIONS_TOGGLE_SELECTOR, _this.toggleVisibility);
                } else {
                    // if annotations can't be shown, disable the toggle button and add a tooltip
                    (0, _jquery2.default)(ANNOTATIONS_TOGGLE_SELECTOR).attr({
                        'aria-disabled': 'true',
                        'data-disabled-title': _aui.I18n.getText('bitbucket.codeinsights.annotations.disabled.title')
                    }).addClass('aui-dropdown2-disabled').tooltip({
                        gravity: 'e',
                        delayIn: 0,
                        title: 'data-disabled-title'
                    });
                }
            };

            this.destroy = function () {
                (0, _jquery2.default)(document).off('aui-dropdown2-show', _this.onFirstOpen).off('click', _this.toggleVisibility);
            };

            this.onFirstOpen = function () {
                var $toggler = (0, _jquery2.default)(ANNOTATIONS_TOGGLE_SELECTOR);

                if (!_this.areAnnotationsAvailable) {
                    $toggler.attr('aria-disabled', true).addClass('aui-dropdown2-disabled');
                }

                // set the initial state of the checkbox to unchecked if the user has previously
                // hidden the annotations.
                if (!(0, _insightPreferences.getAnnotationVisibilitySetting)()) {
                    // call `uncheck` directly on the skated aui-dropdown2 DOM element
                    $toggler[0].uncheck();
                }
            };

            this.toggleVisibility = function (e) {
                // e.target is an aui-dropdown2-checkbox skated element
                var checked = e.target.isChecked();
                (0, _insightPreferences.toggleAnnotationVisibilitySetting)(checked);
                _this.onChange(checked);
            };

            this.areAnnotationsAvailable = areAnnotationsAvailable;
            this.onChange = onChange;
        }

        /**
         * Handle setting the initial toggle state when the diff options menu is opened.
         */


        /**
         * handle the toggle change of annotations' visibility
         * @param {HTMLElement} e
         */


        return AnnotationToggle;
    }();

    exports.default = AnnotationToggle;
    module.exports = exports['default'];
});