define('bitbucket-plugin-code-insights/internal/insight-preferences', ['exports', 'lodash', 'bitbucket/internal/util/client-storage', './analytics'], function (exports, _lodash, _clientStorage, _analytics) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.toggleAnnotationVisibilitySetting = toggleAnnotationVisibilitySetting;
    exports.getAnnotationVisibilitySetting = getAnnotationVisibilitySetting;
    exports.setChangedLinesOnlySetting = setChangedLinesOnlySetting;
    exports.getChangedLinesOnlySetting = getChangedLinesOnlySetting;

    var _clientStorage2 = _interopRequireDefault(_clientStorage);

    var _analytics2 = _interopRequireDefault(_analytics);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    // only initialize the storageKey when required
    var storageKey = (0, _lodash.once)(function () {
        return _clientStorage2.default.buildKey(['text-view', 'code-insights-options'], 'user');
    });

    var defaultOptions = {
        visible: true,
        changedLinesOnly: true
    };

    var getSettings = function getSettings() {
        return _extends({}, defaultOptions, _clientStorage2.default.getItem(storageKey()));
    };

    var updateSettings = function updateSettings(updates) {
        var oldSettings = getSettings();
        var newSettings = _extends({}, oldSettings, updates);
        (0, _analytics2.default)('stash.client.codeinsights.diffsettings.changed', {
            'visible.prev': oldSettings.visible,
            'visible.new': newSettings.visible,
            'changedLinesOnly.prev': oldSettings.changedLinesOnly,
            'changedLinesOnly.new': newSettings.changedLinesOnly
        });
        _clientStorage2.default.setItem(storageKey(), newSettings);
    };

    /**
     * Toggle the annotation visibility setting
     * @param {boolean} visible
     */
    function toggleAnnotationVisibilitySetting(visible) {
        updateSettings({ visible: visible });
    }

    /**
     * Get the annotation visibility setting
     * @returns {boolean}
     */
    function getAnnotationVisibilitySetting() {
        return getSettings().visible;
    }

    /**
     * Show annotations on only changed lines or all lines in the file
     * @param {string} changedLinesOnly
     */
    function setChangedLinesOnlySetting(changedLinesOnly) {
        updateSettings({ changedLinesOnly: changedLinesOnly });
    }

    /**
     * Get the annotation visibility setting
     * @returns {string}
     */
    function getChangedLinesOnlySetting() {
        return getSettings().changedLinesOnly;
    }
});