/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.rest;

import com.atlassian.bitbucket.codeinsights.report.InsightDataType;
import com.atlassian.bitbucket.codeinsights.report.InsightReportData;
import com.atlassian.bitbucket.codeinsights.report.InsightResult;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestInsightReportData;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.UrlUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

public class RestSetInsightReportRequest
extends RestMapEntity {
    public static final RestSetInsightReportRequest EXAMPLE = new RestSetInsightReportRequest((List<InsightReportData>)ImmutableList.of((Object)new InsightReportData.Builder("Some title", "Some value").type(InsightDataType.TEXT).build(), (Object)new InsightReportData.Builder("Build length", 60000).type(InsightDataType.DURATION).build(), (Object)new InsightReportData.Builder("Download link", ImmutableMap.of((Object)"linktext", (Object)"installer.zip", (Object)"href", (Object)"https://link.to.download/file.zip")).type(InsightDataType.LINK).build(), (Object)new InsightReportData.Builder("Build started date", 1539656375).type(InsightDataType.DATE).build(), (Object)new InsightReportData.Builder("Code coverage", 85).type(InsightDataType.PERCENTAGE).build(), (Object)new InsightReportData.Builder("Some count", 5).type(InsightDataType.NUMBER).build()), new Date(), "This is the details of the report, it can be a longer string describing the report", UrlUtils.uncheckedCreateURI((String)"http://insight.host.com"), UrlUtils.uncheckedCreateURI((String)"http://insight.host.com/logo"), InsightResult.PASS, "report.title", "Reporter/tool that produced this report");

    public RestSetInsightReportRequest() {
    }

    RestSetInsightReportRequest(Map<String, ?> values) {
        super(values);
    }

    public RestSetInsightReportRequest(List<InsightReportData> data, Date createdDate, String details, URI link, URI logoUrl, InsightResult result, String title, String reporter) {
        this.putIfNotNull("data", data == null ? null : data.stream().map(RestInsightReportData::new).collect(MoreCollectors.toImmutableList()));
        this.putIfNotNull("details", details);
        this.putIfNotNull("title", title);
        this.putIfNotNull("reporter", reporter);
        if (createdDate != null) {
            this.putIfNotNull("createdDate", createdDate.getTime());
        }
        if (link != null) {
            this.putIfNotNull("link", link.toASCIIString());
        }
        if (logoUrl != null) {
            this.putIfNotNull("logoUrl", logoUrl.toASCIIString());
        }
        if (result != null) {
            this.putIfNotNull("result", result.toString());
        }
    }

    @NotNull(message="{bitbucket.rest.codeinsights.error.data.format}")
    @Size(max=6, message="{bitbucket.rest.codeinsights.error.data.size}")
    @Valid
    public @NotNull(message="{bitbucket.rest.codeinsights.error.data.format}") @Size(max=6, message="{bitbucket.rest.codeinsights.error.data.size}") @Valid List<RestInsightReportData> getData() {
        Object changes = this.get("data");
        if (changes == null) {
            return Collections.emptyList();
        }
        if (changes instanceof List) {
            List changeList = (List)changes;
            return (List)changeList.stream().map(RestInsightReportData::valueOf).filter(Objects::nonNull).collect(MoreCollectors.toImmutableList());
        }
        return null;
    }

    @Nullable
    public String getDetails() {
        return this.getStringProperty("details");
    }

    @Nullable
    public String getLink() {
        return this.getStringProperty("link");
    }

    @Nullable
    public String getLogoUrl() {
        return this.getStringProperty("logoUrl");
    }

    @Nullable
    @Size(max=450, message="{bitbucket.rest.codeinsights.error.reporter.length}")
    public @Size(max=450, message="{bitbucket.rest.codeinsights.error.reporter.length}") String getReporter() {
        return this.getStringProperty("reporter");
    }

    @Nullable
    @Pattern(regexp="FAIL|PASS", message="{bitbucket.rest.codeinsights.error.result.pattern}")
    public @Pattern(regexp="FAIL|PASS", message="{bitbucket.rest.codeinsights.error.result.pattern}") String getResult() {
        return this.getStringProperty("result");
    }

    @NotBlank(message="{bitbucket.rest.codeinsights.error.title.required}")
    @Size(max=450, message="{bitbucket.rest.codeinsights.error.title.length}")
    public @NotBlank(message="{bitbucket.rest.codeinsights.error.title.required}") @Size(max=450, message="{bitbucket.rest.codeinsights.error.title.length}") String getTitle() {
        return this.getStringProperty("title");
    }
}

