/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.rest;

import com.atlassian.bitbucket.codeinsights.report.InsightDataType;
import com.atlassian.bitbucket.codeinsights.report.InsightReport;
import com.atlassian.bitbucket.codeinsights.report.InsightReportData;
import com.atlassian.bitbucket.codeinsights.report.InsightResult;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestInsightReportData;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=InsightReport.class)
public class RestInsightReport
extends RestMapEntity {
    public static final RestInsightReport EXAMPLE = new RestInsightReport((List<InsightReportData>)ImmutableList.of((Object)new InsightReportData.Builder("data.title", 9).type(InsightDataType.NUMBER).build()), 12345L, "This is the details of the report, it can be a longer string describing the report", "report.key", "http://integration.host.com", "http://integration.host.com/logo", "PASS", "report.title", "Reporter/tool that produced this report");
    public static final RestPage<RestInsightReport> EXAMPLE_PAGE = RestDocUtils.pageOf((Object[])new RestInsightReport[]{EXAMPLE});
    static final String CREATED_DATE = "createdDate";
    static final String DATA = "data";
    static final String DETAILS = "details";
    static final String KEY = "key";
    static final String LINK = "link";
    static final String LOGO_URL = "logoUrl";
    static final String REPORTER = "reporter";
    static final String RESULT = "result";
    static final String TITLE = "title";

    public RestInsightReport() {
    }

    RestInsightReport(Map<String, ?> values) {
        super(values);
    }

    public RestInsightReport(InsightReport report) {
        this(report.getData(), report.getCreatedDate().getTime(), report.getDetails().orElse(null), report.getKey(), report.getLink().map(URI::toASCIIString).orElse(null), report.getLogoUrl().map(URI::toASCIIString).orElse(null), report.getResult().map(Enum::toString).orElse(null), report.getTitle(), report.getReporter().orElse(null));
    }

    RestInsightReport(List<InsightReportData> data, Long createdDate, String details, String key, String link, String logoUrl, String result, String title, String reporter) {
        this.putIfNotEmpty(DATA, this.toRestData(data));
        this.putIfNotNull(CREATED_DATE, createdDate);
        this.putIfNotNull(DETAILS, details);
        this.put(KEY, key);
        this.putIfNotNull(LINK, link);
        this.putIfNotNull(LOGO_URL, logoUrl);
        this.putIfNotNull(RESULT, result);
        this.put(TITLE, title);
        this.putIfNotNull(REPORTER, reporter);
    }

    @Nonnull
    public Date getCreatedDate() {
        return new Date(this.getLongProperty(CREATED_DATE));
    }

    @Nonnull
    public List<RestInsightReportData> getData() {
        Object object = this.get(DATA);
        if (object instanceof List) {
            List dataList = (List)object;
            return (List)dataList.stream().map(RestInsightReportData::valueOf).collect(MoreCollectors.toImmutableList());
        }
        return Collections.emptyList();
    }

    @Nonnull
    public Optional<String> getDetails() {
        return Optional.ofNullable(this.getStringProperty(DETAILS));
    }

    @Nonnull
    public String getKey() {
        return this.getStringProperty(KEY);
    }

    @Nonnull
    public Optional<URI> getLink() {
        return Optional.ofNullable(this.getStringProperty(LINK)).map(URI::create);
    }

    @Nonnull
    public Optional<URI> getLogoUrl() {
        return Optional.ofNullable(this.getStringProperty(LOGO_URL)).map(URI::create);
    }

    @Nonnull
    public Optional<String> getReporter() {
        return Optional.ofNullable(this.getStringProperty(REPORTER));
    }

    @Nonnull
    public Optional<InsightResult> getResult() {
        return Optional.ofNullable(this.getEnumProperty(RESULT, InsightResult.class));
    }

    @Nonnull
    public String getTitle() {
        return this.getStringProperty(TITLE);
    }

    private List<RestInsightReportData> toRestData(List<InsightReportData> data) {
        return data == null ? null : (List)data.stream().map(RestInsightReportData::new).collect(MoreCollectors.toImmutableList());
    }
}

