define('bitbucket-plugin-code-insights/internal/summary-link/summary-link-container', ['exports', 'lodash', 'react', 'react-redux', 'reselect', '../feature-discovery/feature-discovery', '../report', '../state/report-state', './summary-link'], function (exports, _lodash, _react, _reactRedux, _reselect, _featureDiscovery, _report, _reportState, _summaryLink) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.makeMapStateToProps = undefined;

    var _react2 = babelHelpers.interopRequireDefault(_react);

    var _summaryLink2 = babelHelpers.interopRequireDefault(_summaryLink);

    var _resultRank;

    var resultRank = (_resultRank = {}, babelHelpers.defineProperty(_resultRank, _report.ResultEnum.FAIL, 0), babelHelpers.defineProperty(_resultRank, _report.ResultEnum.PASS, 1), babelHelpers.defineProperty(_resultRank, 'null', 2), _resultRank);

    var pullRequestSelector = function pullRequestSelector(state, props) {
        return props.pullRequest;
    };

    //@VisibleForTesting
    var makeMapStateToProps = exports.makeMapStateToProps = function makeMapStateToProps() {
        var _selectors = (0, _reportState.selectors)(pullRequestSelector),
            reportsSelector = _selectors.reportsSelector,
            allReportsLoadedSelector = _selectors.allReportsLoadedSelector,
            areReportsLoadingSelector = _selectors.areReportsLoadingSelector;

        // get an array of [result, resultCount] pairs, sorted FAIL, PASS, (no result)


        var primaryResultCountsSelector = (0, _reselect.createSelector)(reportsSelector, function (reports) {
            return (0, _lodash.chain)(reports).groupBy(function (report) {
                return report.result || '';
            }).map(function (values, result) {
                return [result || null, values.length];
            }).sortBy(function (_ref) {
                var _ref2 = babelHelpers.slicedToArray(_ref, 1),
                    result = _ref2[0];

                return resultRank[result];
            }).first().value() || [null, 0];
        });

        return (0, _reselect.createSelector)(allReportsLoadedSelector, areReportsLoadingSelector, reportsSelector, primaryResultCountsSelector, function (allFetched, loading, reports, _ref3) {
            var _ref4 = babelHelpers.slicedToArray(_ref3, 2),
                result = _ref4[0],
                resultCount = _ref4[1];

            return {
                allFetched: allFetched,
                loading: loading,
                reportCount: reports.length,
                onlyReport: reports.length === 1 ? reports[0] : null,
                result: result,
                resultCount: resultCount
            };
        });
    };

    var mapDispatchToProps = {
        loadReports: _reportState.actionCreators.loadReports
    };

    var SummaryLinkContainer = function (_PureComponent) {
        babelHelpers.inherits(SummaryLinkContainer, _PureComponent);

        function SummaryLinkContainer() {
            babelHelpers.classCallCheck(this, SummaryLinkContainer);
            return babelHelpers.possibleConstructorReturn(this, (SummaryLinkContainer.__proto__ || Object.getPrototypeOf(SummaryLinkContainer)).apply(this, arguments));
        }

        babelHelpers.createClass(SummaryLinkContainer, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                var _props = this.props,
                    allFetched = _props.allFetched,
                    reportCount = _props.reportCount,
                    loading = _props.loading,
                    loadReports = _props.loadReports,
                    pullRequest = _props.pullRequest;

                if (!(allFetched || reportCount || loading)) {
                    loadReports({ pullRequest: pullRequest });
                }
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate(prevProps) {
                var _props2 = this.props,
                    allFetched = _props2.allFetched,
                    reportCount = _props2.reportCount;

                /*
                 * If there are reports then show the firstUse feature discovery
                 * If there are no reports then show the initial feature discovery
                 */
                if (!prevProps.allFetched && allFetched) {
                    if (reportCount > 0) {
                        (0, _featureDiscovery.firstUseFeatureDiscovery)();
                    } else {
                        (0, _featureDiscovery.initialFeatureDiscovery)();
                    }
                }
            }
        }, {
            key: 'render',
            value: function render() {
                return _react2.default.createElement(_summaryLink2.default, this.props);
            }
        }]);
        return SummaryLinkContainer;
    }(_react.PureComponent);

    exports.default = (0, _reactRedux.connect)(makeMapStateToProps, mapDispatchToProps)(SummaryLinkContainer);
});