define('bitbucket-plugin-code-insights/internal/state/annotations-by-path-state', ['exports', 'lodash', 'redux', 'reselect', 'bitbucket/util/navbuilder', 'bitbucket/internal/util/reducers', 'bitbucket/internal/util/rest-actor', './insight-shared-state', './insight-state-utils'], function (exports, _lodash, _redux, _reselect, _navbuilder, _reducers, _restActor, _insightSharedState, _insightStateUtils) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.reducers = exports.selectors = exports.actors = exports.actionCreators = undefined;

    var _navbuilder2 = babelHelpers.interopRequireDefault(_navbuilder);

    var LOAD_ANNOTATIONS_FOR_PATH = 'LOAD_ANNOTATIONS_FOR_PATH';
    var LOAD_ANNOTATIONS_FOR_PATH_SUCCESS = 'LOAD_ANNOTATIONS_FOR_PATH_SUCCESS';
    var LOAD_ANNOTATIONS_FOR_PATH_FAILURE = 'LOAD_ANNOTATIONS_FOR_PATH_FAILURE';

    var actionCreators = exports.actionCreators = {
        loadAnnotationsForPath: function loadAnnotationsForPath(_ref) {
            var path = _ref.path,
                pullRequest = _ref.pullRequest,
                mergeCommit = _ref.mergeCommit;
            return {
                type: LOAD_ANNOTATIONS_FOR_PATH,
                payload: {
                    pullRequest: pullRequest,
                    path: path,
                    mergeCommit: mergeCommit
                },
                meta: {
                    successType: LOAD_ANNOTATIONS_FOR_PATH_SUCCESS,
                    failureType: LOAD_ANNOTATIONS_FOR_PATH_FAILURE
                }
            };
        }
    };

    var actors = exports.actors = [(0, _restActor.restActorForType)(LOAD_ANNOTATIONS_FOR_PATH, function (action) {
        return {
            url: _navbuilder2.default.rest('insights').pullRequest(action.payload.pullRequest).addPathComponents('annotations').withParams({
                path: action.payload.path
            }).build(),
            statusCode: {
                '*': false
            }
        };
    })];

    var selectors = exports.selectors = function selectors(_ref2) {
        var pullRequestSelector = _ref2.pullRequestSelector,
            diffSelector = _ref2.diffSelector;

        var _globalSelectors = (0, _insightSharedState.selectors)(pullRequestSelector),
            annotationRequestsByPathStateSelector = _globalSelectors.annotationRequestsByPathStateSelector,
            annotationsByPathStateSelector = _globalSelectors.annotationsByPathStateSelector,
            fileInfoSelector = _globalSelectors.fileInfoSelector;

        var annotationsLoadingForDiffSelector = (0, _reselect.createSelector)(annotationRequestsByPathStateSelector, diffSelector, function (annotationRequestsByPath, diff) {
            return (0, _lodash.get)(annotationRequestsByPath, [diff.path, 'loading'], false);
        });

        var annotationsForDiffSelector = (0, _reselect.createSelector)(annotationsByPathStateSelector, diffSelector, function (annotationsByPath, diff) {
            return (0, _lodash.get)(annotationsByPath, [diff.toHash, 'values', diff.path], null);
        });

        var annotationsTruncatedByPathSelector = (0, _reselect.createSelector)(fileInfoSelector, diffSelector, function (fileInfo, diff) {
            return (0, _lodash.get)(fileInfo, [diff.toHash, 'values', diff.path, 'truncated'], null);
        });

        var sourceCommitForAnnotationsSelector = (0, _reselect.createSelector)(annotationsByPathStateSelector, diffSelector, function (annotationsByPath, diff) {
            return (0, _lodash.get)(annotationsByPath, [diff.toHash, 'sourceCommit'], null);
        });

        return {
            annotationsForDiffSelector: annotationsForDiffSelector,
            annotationsTruncatedByPathSelector: annotationsTruncatedByPathSelector,
            annotationsLoadingForDiffSelector: annotationsLoadingForDiffSelector,
            sourceCommitForAnnotationsSelector: sourceCommitForAnnotationsSelector
        };
    };

    // In some cases we key our state tree by a PR's merge commit
    // this is so that if the merge commit changes, we pull in new data.
    // NOTE: Since we're pulling the merge commit in from the request action, it might be inaccurate!
    // We don't get back a merge commit with the annotations, so we just kinda hope it matches the diff we're looking at.
    var reduceByMergeCommit = (0, _reducers.singleKeyedReducer)(function (_ref3) {
        var type = _ref3.type,
            payload = _ref3.payload,
            meta = _ref3.meta;

        switch (type) {
            case LOAD_ANNOTATIONS_FOR_PATH_SUCCESS:
                return meta.originalAction.payload.mergeCommit;
        }
    }, 'commit');

    // key some state off of a file path (e.g., annotations by path)
    var reduceByPath = (0, _reducers.multiKeyedReducer)(function (_ref4) {
        var type = _ref4.type,
            payload = _ref4.payload,
            meta = _ref4.meta;

        switch (type) {
            case LOAD_ANNOTATIONS_FOR_PATH:
                return payload.path;
            case LOAD_ANNOTATIONS_FOR_PATH_SUCCESS:
            case LOAD_ANNOTATIONS_FOR_PATH_FAILURE:
                return meta.originalAction.payload.path;
        }
    });

    var addUniqueId = function addUniqueId(o) {
        return babelHelpers.extends({
            id: (0, _lodash.uniqueId)()
        }, o);
    };

    // Note requests are not stored within a merge commit subtree.
    // This is because they store some state from before the request is made, and some from after. We need a consistent state
    // to talk about whether there are errors or whether annotations are loading.
    // If we ever add support for other diffs, we'll need to split those by commit, but EFFECTIVE pr requests should not be.
    var reducers = exports.reducers = {
        requests: reduceByPath((0, _insightStateUtils.requestsReducer)(LOAD_ANNOTATIONS_FOR_PATH, LOAD_ANNOTATIONS_FOR_PATH_SUCCESS, LOAD_ANNOTATIONS_FOR_PATH_FAILURE)),
        annotations: reduceByMergeCommit((0, _redux.combineReducers)({
            sourceCommit: (0, _reducers.reduceByType)(null, babelHelpers.defineProperty({}, LOAD_ANNOTATIONS_FOR_PATH_SUCCESS, function (_, _ref5) {
                var payload = _ref5.payload;
                return (0, _insightStateUtils.getPRSourceCommit)(payload.pullRequest);
            })),
            values: reduceByPath((0, _reducers.reduceByType)(null, babelHelpers.defineProperty({}, LOAD_ANNOTATIONS_FOR_PATH_SUCCESS, function (state, action) {
                return action.payload.annotations.map(addUniqueId);
            })))
        })),
        fileInfo: reduceByMergeCommit((0, _redux.combineReducers)({
            values: reduceByPath((0, _reducers.reduceByType)(null, babelHelpers.defineProperty({}, LOAD_ANNOTATIONS_FOR_PATH_SUCCESS, function (state, action) {
                return {
                    truncated: action.payload.truncated
                };
            })))
        }))
    };
});