define('bitbucket-plugin-code-insights/internal/report-inline-dialog/report-inline-dialog', ['module', 'exports', '@atlassian/aui', 'lodash', 'react', 'bitbucket/internal/bbui/aui-react/inline-dialog', 'bitbucket/internal/bbui/tipsy/tipsy', '../annotation-table/reporter-logo'], function (module, exports, _aui, _lodash, _react, _inlineDialog, _tipsy, _reporterLogo) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = babelHelpers.interopRequireDefault(_react);

    var _inlineDialog2 = babelHelpers.interopRequireDefault(_inlineDialog);

    var _tipsy2 = babelHelpers.interopRequireDefault(_tipsy);

    var _reporterLogo2 = babelHelpers.interopRequireDefault(_reporterLogo);

    var ListItem = function ListItem(_ref) {
        var report = _ref.report,
            annotationCount = _ref.annotationCount;

        return _react2.default.createElement(
            'li',
            null,
            _react2.default.createElement(_reporterLogo2.default, { report: report }),
            _react2.default.createElement(
                _tipsy2.default,
                {
                    className: 'report-title',
                    tooltipClassName: 'insights-info-report-title-tooltip',
                    title: report.title || report.reporter,
                    hoverable: false,
                    condition: _tipsy2.default.isTruncatedCondition
                },
                report.title
            ),
            _react2.default.createElement(
                'aui-badge',
                {
                    title: _aui.I18n.getText('bitbucket.codeinsights.report.list.annotation.count', annotationCount)
                },
                annotationCount
            )
        );
    };

    exports.default = function (_ref2) {
        var infoDialogId = _ref2.infoDialogId,
            reportsByKey = _ref2.reportsByKey,
            annotations = _ref2.annotations;

        var list = void 0;
        if ((0, _lodash.get)(annotations, 'length')) {
            var countByReportKey = (0, _lodash.countBy)(annotations, 'reportKey');
            list = Object.values(reportsByKey).sort(function (reportA, reportB) {
                return reportA.title.localeCompare(reportB.title);
            }).filter(function (report) {
                return countByReportKey[report.key];
            }).map(function (report) {
                return _react2.default.createElement(ListItem, {
                    key: report.key,
                    report: report,
                    annotationCount: countByReportKey[report.key]
                });
            });
        }
        return _react2.default.createElement(
            _inlineDialog2.default,
            {
                id: infoDialogId,
                className: infoDialogId + ' report-list-dialog',
                alignment: 'bottom center'
            },
            _react2.default.createElement(
                'h5',
                null,
                'Annotations'
            ),
            _react2.default.createElement(
                'ul',
                { className: 'info-dialog-report-list' },
                list
            )
        );
    };

    module.exports = exports['default'];
});