define('bitbucket-plugin-code-insights/internal/report-dialog/report-dialog-detail-container', ['module', 'exports', 'react', 'react-redux', 'reselect', '../state/annotations-by-report-state', './report-dialog'], function (module, exports, _react, _reactRedux, _reselect, _annotationsByReportState, _reportDialog) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = babelHelpers.interopRequireDefault(_react);

    var reportKeySelector = function reportKeySelector(state, props) {
        return props.item.key;
    };
    var pullRequestSelector = function pullRequestSelector(state, props) {
        return props.pullRequest;
    };

    var reportDetailMapStateToProps = function reportDetailMapStateToProps() {
        var _selectors = (0, _annotationsByReportState.selectors)({
            pullRequestSelector: pullRequestSelector,
            reportKeySelector: reportKeySelector
        }),
            annotationsForReportSelector = _selectors.annotationsForReportSelector,
            annotationsLoadingForReportSelector = _selectors.annotationsLoadingForReportSelector,
            annotationsErrorsForReportSelector = _selectors.annotationsErrorsForReportSelector,
            annotationsTruncatedForReportSelector = _selectors.annotationsTruncatedForReportSelector;

        return (0, _reselect.createStructuredSelector)({
            annotations: annotationsForReportSelector,
            annotationsLoading: annotationsLoadingForReportSelector,
            annotationsErrors: annotationsErrorsForReportSelector,
            truncated: annotationsTruncatedForReportSelector
        });
    };

    var reportDetailMapDispatchToProps = {
        loadAnnotations: _annotationsByReportState.actionCreators.loadAnnotationsForReport
    };

    var ReportDetailContainer = function (_PureComponent) {
        babelHelpers.inherits(ReportDetailContainer, _PureComponent);

        function ReportDetailContainer() {
            babelHelpers.classCallCheck(this, ReportDetailContainer);
            return babelHelpers.possibleConstructorReturn(this, (ReportDetailContainer.__proto__ || Object.getPrototypeOf(ReportDetailContainer)).apply(this, arguments));
        }

        babelHelpers.createClass(ReportDetailContainer, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                this.maybeLoadAnnotations();
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate() {
                this.maybeLoadAnnotations();
            }
        }, {
            key: 'maybeLoadAnnotations',
            value: function maybeLoadAnnotations() {
                var _props = this.props,
                    pullRequest = _props.pullRequest,
                    report = _props.item,
                    annotations = _props.annotations,
                    annotationsLoading = _props.annotationsLoading,
                    loadAnnotations = _props.loadAnnotations,
                    annotationsErrors = _props.annotationsErrors;

                if (annotations == null && !annotationsLoading && !annotationsErrors) {
                    loadAnnotations({ pullRequest: pullRequest, report: report });
                }
            }
        }, {
            key: 'render',
            value: function render() {
                return _react2.default.createElement(_reportDialog.ReportDetail, this.props);
            }
        }]);
        return ReportDetailContainer;
    }(_react.PureComponent);

    exports.default = (0, _reactRedux.connect)(reportDetailMapStateToProps, reportDetailMapDispatchToProps)(ReportDetailContainer);
    module.exports = exports['default'];
});