define('bitbucket-plugin-code-insights/internal/pull-request-overview/pull-request-overview', ['module', 'exports', 'react', 'react-redux', 'bitbucket/util/events', 'bitbucket/internal/feature/file-content/diff-view-options', 'bitbucket/internal/util/history', '../insight-preferences', '../report-dialog/report-dialog-container', '../store', '../summary-link/summary-link-container'], function (module, exports, _react, _reactRedux, _events, _diffViewOptions, _history, _insightPreferences, _reportDialogContainer, _store, _summaryLinkContainer) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = babelHelpers.interopRequireDefault(_react);

    var _events2 = babelHelpers.interopRequireDefault(_events);

    var _diffViewOptions2 = babelHelpers.interopRequireDefault(_diffViewOptions);

    var _history2 = babelHelpers.interopRequireDefault(_history);

    var _reportDialogContainer2 = babelHelpers.interopRequireDefault(_reportDialogContainer);

    var _store2 = babelHelpers.interopRequireDefault(_store);

    var _summaryLinkContainer2 = babelHelpers.interopRequireDefault(_summaryLinkContainer);

    var PullRequestOverview = function (_PureComponent) {
        babelHelpers.inherits(PullRequestOverview, _PureComponent);

        function PullRequestOverview() {
            var _ref;

            var _temp, _this, _ret;

            babelHelpers.classCallCheck(this, PullRequestOverview);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = babelHelpers.possibleConstructorReturn(this, (_ref = PullRequestOverview.__proto__ || Object.getPrototypeOf(PullRequestOverview)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
                dialogOpen: false
            }, _this.onClickLink = function () {
                _this.setState({ dialogOpen: true });
            }, _this.onCloseDialog = function () {
                _this.setState({ dialogOpen: false });
            }, _this.onAnnotationLinkClicked = function (e) {
                e.preventDefault();
                (0, _insightPreferences.toggleAnnotationVisibilitySetting)(true);
                // the override needs to be set before the diff starts rendering
                // so the correct kind of diffView is used.
                _events2.default.once('bitbucket.internal.feature.fileContent.handlerRequested', function (_ref2) {
                    var diffViewOptions = _ref2.diffViewOptions;

                    diffViewOptions.setSoftOverride('diffType', 'unified', false);
                    diffViewOptions.setSoftOverride('ignoreWhitespace', false, false);
                });
                _this.onCloseDialog();
                _history2.default.pushState(null, null, e.currentTarget.href);
            }, _temp), babelHelpers.possibleConstructorReturn(_this, _ret);
        }

        babelHelpers.createClass(PullRequestOverview, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    pullRequest = _props.pullRequest,
                    containerEl = _props.containerEl;

                return _react2.default.createElement(
                    _reactRedux.Provider,
                    { store: _store2.default },
                    _react2.default.createElement(
                        _react.Fragment,
                        null,
                        _react2.default.createElement(_summaryLinkContainer2.default, {
                            pullRequest: pullRequest,
                            onClick: this.onClickLink,
                            containerEl: containerEl,
                            className: 'code-insights-overview'
                        }),
                        this.state.dialogOpen && _react2.default.createElement(_reportDialogContainer2.default, {
                            pullRequest: pullRequest,
                            onClose: this.onCloseDialog,
                            onAnnotationLinkClicked: this.onAnnotationLinkClicked
                        })
                    )
                );
            }
        }]);
        return PullRequestOverview;
    }(_react.PureComponent);

    exports.default = PullRequestOverview;
    module.exports = exports['default'];
});