define('bitbucket-plugin-code-insights/internal/pull-request-diff/insights-toolbar-button', ['module', 'exports', '@atlassian/aui', 'classnames', 'lodash', 'react', 'bitbucket/internal/bbui/aui-react/spinner', 'bitbucket/internal/widget/icons/icons', '../analytics'], function (module, exports, _aui, _classnames, _lodash, _react, _spinner, _icons, _analytics) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _classnames2 = babelHelpers.interopRequireDefault(_classnames);

    var _react2 = babelHelpers.interopRequireDefault(_react);

    var _spinner2 = babelHelpers.interopRequireDefault(_spinner);

    var _analytics2 = babelHelpers.interopRequireDefault(_analytics);

    var InsightsButton = function (_Component) {
        babelHelpers.inherits(InsightsButton, _Component);

        function InsightsButton() {
            babelHelpers.classCallCheck(this, InsightsButton);
            return babelHelpers.possibleConstructorReturn(this, (InsightsButton.__proto__ || Object.getPrototypeOf(InsightsButton)).apply(this, arguments));
        }

        babelHelpers.createClass(InsightsButton, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    visible = _props.visible,
                    loading = _props.loading,
                    outdated = _props.outdated,
                    annotations = _props.annotations,
                    infoDialogId = _props.infoDialogId,
                    _props$reportsByKey = _props.reportsByKey,
                    reportsByKey = _props$reportsByKey === undefined ? {} : _props$reportsByKey,
                    annotationsTruncated = _props.annotationsTruncated;

                var hasAnnotations = annotations && annotations.length > 0;
                var iconProps = {
                    tooltip: true,
                    offset: 7,
                    gravity: 'ne'
                };

                if (!hasAnnotations) {
                    iconProps.title = _aui.I18n.getText('bitbucket.codeinsights.diff.insights.button.no.annotations');
                    if (annotationsTruncated) {
                        iconProps.title = _aui.I18n.getText('bitbucket.codeinsights.diff.insights.button.truncated.annotations');
                        (0, _analytics2.default)('stash.client.codeinsights.pullrequest.diff.annotations.truncated');
                    }
                } else {
                    var reportCount = (0, _lodash.chain)(annotations).countBy('reportKey').keys().intersection(Object.keys(reportsByKey)).size().value();
                    iconProps.title = _aui.I18n.getText('bitbucket.codeinsights.diff.insights.button.report.count', reportCount);
                    // make sure there is a report count before firing analytics.
                    // annotations and reports come in separately so check here to avoid double-requesting
                    if (reportCount) {
                        (0, _analytics2.default)('stash.client.codeinsights.pullrequest.diff.annotations.loaded', {
                            'report.count': reportCount,
                            'annotations.count': annotations.length,
                            'annotations.outdated': outdated
                        });
                    }
                }

                // N.B. the data-aui-trigger attribute should always remain present so that AUI / Skate
                // will correctly resolve this as a trigger
                return _react2.default.createElement(
                    'button',
                    {
                        disabled: !hasAnnotations,
                        className: (0, _classnames2.default)('aui-button', 'aui-button-subtle', 'code-insights-button', {
                            'annotations-outdated': outdated,
                            'annotations-off': !visible,
                            loading: loading
                        }),
                        'data-aui-trigger': true,
                        'aria-controls': infoDialogId
                    },
                    loading ? _react2.default.createElement(_spinner2.default, null) : _react2.default.createElement(_icons.AddonIcon, iconProps)
                );
            }
        }]);
        return InsightsButton;
    }(_react.Component);

    InsightsButton.defaultProps = {
        visible: true,
        loading: false,
        annotations: []
    };

    exports.default = InsightsButton;
    module.exports = exports['default'];
});