define('bitbucket-plugin-code-insights/internal/pull-request-diff/insights-toolbar-button-init', ['module', 'exports', '@atlassian/aui', 'lodash', 'react', 'react-dom', 'bitbucket/util/navbuilder', '../outdated-annotations/outdated-annotations', '../report-inline-dialog/report-inline-dialog', './insights-toolbar-button'], function (module, exports, _aui, _lodash, _react, _reactDom, _navbuilder, _outdatedAnnotations, _reportInlineDialog, _insightsToolbarButton) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = babelHelpers.interopRequireDefault(_react);

    var _reactDom2 = babelHelpers.interopRequireDefault(_reactDom);

    var _navbuilder2 = babelHelpers.interopRequireDefault(_navbuilder);

    var _outdatedAnnotations2 = babelHelpers.interopRequireDefault(_outdatedAnnotations);

    var _reportInlineDialog2 = babelHelpers.interopRequireDefault(_reportInlineDialog);

    var _insightsToolbarButton2 = babelHelpers.interopRequireDefault(_insightsToolbarButton);

    var CLIENT_WEB_ITEM_SELECTOR = '.code-insights-button-placeholder';

    /**
     * Returns an object which can render and destroy the InsightsButton component
     *
     * @return {{ render: (function(state)), destroy: (function())}}
     */
    function initInsightsButton() {
        var webItem = document.querySelector(CLIENT_WEB_ITEM_SELECTOR);

        // When switching between tabs rapidly (e.g. Overview <> Diff), the DOM element is already purged before this code runs.
        // In that case, we'll return an Object with no-op methods.
        if (!webItem) {
            return { render: function render() {}, destroy: function destroy() {} };
        }

        // We know that this client web item is rendered inside a div.aui-buttons as an only child (aww);
        // we'll use this div as the container.
        var container = webItem.parentNode;
        var infoDialogId = 'annotations-info-dialog';
        return {
            render: function render(_ref) {
                var visible = _ref.visible,
                    loading = _ref.loading,
                    annotations = _ref.annotations,
                    pullRequest = _ref.pullRequest,
                    reportsByKey = _ref.reportsByKey,
                    truncated = _ref.truncated;

                var outdated = (0, _lodash.get)(annotations, '0.outdated') === true;
                var currentUri = _navbuilder2.default.parse(window.location.href);
                var browsingToOutdated = currentUri.getQueryParamValue('outdated') === 'true';
                if (browsingToOutdated && annotations) {
                    // immediately ditch the outdated query param so it doesn't stick around
                    // between file browsing
                    var href = currentUri.deleteQueryParam('outdated').toString();
                    history.replaceState(null, null, href);
                }

                var dialogContent = void 0;
                if (outdated) {
                    dialogContent = _react2.default.createElement(_outdatedAnnotations2.default, {
                        infoDialogId: infoDialogId,
                        annotations: annotations,
                        reportsByKey: reportsByKey,
                        pullRequest: pullRequest,
                        showInfoDialog: browsingToOutdated
                    });
                } else if ((0, _lodash.get)(annotations, 'length')) {
                    dialogContent = _react2.default.createElement(_reportInlineDialog2.default, {
                        infoDialogId: infoDialogId,
                        annotations: annotations,
                        reportsByKey: reportsByKey
                    });
                }

                _reactDom2.default.render(_react2.default.createElement(
                    _react.Fragment,
                    null,
                    _react2.default.createElement(_insightsToolbarButton2.default, {
                        visible: visible,
                        outdated: outdated,
                        loading: loading,
                        annotations: annotations,
                        infoDialogId: infoDialogId,
                        reportsByKey: reportsByKey,
                        annotationsTruncated: truncated
                    }),
                    dialogContent
                ), container);
            },
            destroy: function destroy() {
                _reactDom2.default.unmountComponentAtNode(container);
            }
        };
    }

    exports.default = initInsightsButton;
    module.exports = exports['default'];
});