define('bitbucket-plugin-code-insights/internal/pull-request-diff/diff-annotations', ['module', 'exports', '@atlassian/aui', 'lodash', 'react', 'react-dom', 'reselect', 'bitbucket/feature/files/file-handlers', 'bitbucket/internal/bbui/widget/widget', '../annotation/annotation', '../state/annotations-by-path-state', '../state/report-state', '../store'], function (module, exports, _aui, _lodash, _react, _reactDom, _reselect, _fileHandlers, _widget, _annotation, _annotationsByPathState, _reportState, _store) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = babelHelpers.interopRequireDefault(_react);

    var _reactDom2 = babelHelpers.interopRequireDefault(_reactDom);

    var _fileHandlers2 = babelHelpers.interopRequireDefault(_fileHandlers);

    var _widget2 = babelHelpers.interopRequireDefault(_widget);

    var _annotation2 = babelHelpers.interopRequireDefault(_annotation);

    var _store2 = babelHelpers.interopRequireDefault(_store);

    var visibleSelector = function visibleSelector(state, props) {
        return props.visible;
    };
    var mainViewLoadedSelector = function mainViewLoadedSelector(state, props) {
        return props.mainViewLoaded;
    };
    var pullRequestSelector = function pullRequestSelector(state, props) {
        return props.pullRequest;
    };

    var _annotationSelectors = (0, _annotationsByPathState.selectors)({
        pullRequestSelector: pullRequestSelector,
        diffSelector: function diffSelector(state, props) {
            return {
                path: props.path,
                toHash: props.mergeCommit
            };
        }
    }),
        annotationsForDiffSelector = _annotationSelectors.annotationsForDiffSelector,
        annotationsTruncatedByPathSelector = _annotationSelectors.annotationsTruncatedByPathSelector,
        annotationsLoadingForDiffSelector = _annotationSelectors.annotationsLoadingForDiffSelector,
        sourceCommitForAnnotationsSelector = _annotationSelectors.sourceCommitForAnnotationsSelector;

    var _reportSelectors = (0, _reportState.selectors)(pullRequestSelector, sourceCommitForAnnotationsSelector),
        allReportsLoadedSelector = _reportSelectors.allReportsLoadedSelector,
        areReportsLoadingSelector = _reportSelectors.areReportsLoadingSelector,
        reportsByIdSelector = _reportSelectors.reportsByIdSelector;

    // bit sneaky, but since createSelector only runs the handler when one of the selectors changes,
    // we can reuse it to run side-effects on changes in the inputs
    var onRelevantChange = _reselect.createSelector;

    var maybeLoadReports = onRelevantChange(visibleSelector, areReportsLoadingSelector, allReportsLoadedSelector, sourceCommitForAnnotationsSelector, pullRequestSelector, function (visible, reportsLoading, allReportsLoaded, commit, pullRequest) {
        if (visible && !allReportsLoaded && !reportsLoading && commit) {
            _store2.default.dispatch(_reportState.actionCreators.loadReports({ pullRequest: pullRequest, commit: commit }));
        }
    });

    var maybeLoadAnnotations = onRelevantChange(annotationsLoadingForDiffSelector, annotationsForDiffSelector, pullRequestSelector, function (state, props) {
        return props.mergeCommit;
    }, function (state, props) {
        return props.path;
    }, function (annotationsLoading, annotations, pullRequest, mergeCommit, path) {
        // Load even if not visible to reduce the time that annotations can get out of sync with their diff.
        // We can lazily load them again if/when annotations include mergeCommit information on the response.
        if (!annotations && !annotationsLoading) {
            _store2.default.dispatch(_annotationsByPathState.actionCreators.loadAnnotationsForPath({ path: path, pullRequest: pullRequest, mergeCommit: mergeCommit }));
        }
    });

    var renderAnnotations = onRelevantChange(visibleSelector, mainViewLoadedSelector, annotationsForDiffSelector, reportsByIdSelector, function (state, props) {
        return props.sideEffects;
    }, function (visible, mainViewLoaded, annotations, reportsByKey, sideEffects) {
        if (mainViewLoaded) {
            sideEffects.attachAnnotations(visible ? annotations : [], reportsByKey);
        }
    });

    var renderInsightsButton = onRelevantChange(visibleSelector, annotationsLoadingForDiffSelector, annotationsForDiffSelector, annotationsTruncatedByPathSelector, reportsByIdSelector, pullRequestSelector, function (state, props) {
        return props.sideEffects;
    }, function (visible, loading, annotations, truncated, reportsByKey, pullRequest, sideEffects) {
        sideEffects.trigger('updateInsightsButton', {
            visible: visible,
            loading: loading,
            annotations: annotations,
            truncated: truncated,
            reportsByKey: reportsByKey,
            pullRequest: pullRequest
        });
    });

    /**
     * Render a React root in the given element with the given annotations
     * @param {Array<Object>} annotations - the annotations to render in this React root
     * @param {Object} reportsByKey - the reports mapped by key
     * @param {HTMLElement} el
     */
    function renderReactAnnotationRoot(annotations, reportsByKey, el) {
        _reactDom2.default.render(_react2.default.createElement(
            'div',
            { className: 'annotations-container' },
            annotations.map(function (annotation) {
                return _react2.default.createElement(_annotation2.default, {
                    key: annotation.id,
                    annotation: annotation,
                    report: reportsByKey[annotation.reportKey]
                });
            })
        ), el);
    }

    var DiffAnnotations = function (_Widget) {
        babelHelpers.inherits(DiffAnnotations, _Widget);

        function DiffAnnotations(mainView, fileHandlingContext, diffData, pullRequest) {
            babelHelpers.classCallCheck(this, DiffAnnotations);

            var _this = babelHelpers.possibleConstructorReturn(this, (DiffAnnotations.__proto__ || Object.getPrototypeOf(DiffAnnotations)).call(this));

            _this.annotationContainersByLine = {};
            _this.fileAnnotationContainer = null;

            _this.mainView = mainView;
            _this.$container = fileHandlingContext.$container;

            _this.path = fileHandlingContext.fileChange.path.components.join('/');
            _this.mergeCommit = diffData.toHash;
            _this.pullRequest = pullRequest;

            _this.isTextView = [_fileHandlers2.default.builtInHandlers.DIFF_TEXT_SIDE_BY_SIDE, _fileHandlers2.default.builtInHandlers.DIFF_TEXT_UNIFIED].some(function (id) {
                return id === mainView.handlerID;
            });
            return _this;
        }

        babelHelpers.createClass(DiffAnnotations, [{
            key: 'init',
            value: function init(isVisible) {
                var _this2 = this;

                this.visible = isVisible;

                var unsubscribe = _store2.default.subscribe(this.update);

                this._addDestroyable(function () {
                    unsubscribe();
                    (0, _lodash.values)(_this2.annotationContainersByLine).concat(_this2.fileAnnotationContainer || []).forEach(function (_ref) {
                        var el = _ref.el;

                        _reactDom2.default.unmountComponentAtNode(el);
                    });
                });

                this.mainViewLoaded = !this.isTextView;
                if (this.isTextView) {
                    // the diff view isn't actually ready to accept widgets yet at this point, so we need another update
                    // when it becomes ready.
                    this.mainView.on('load', function () {
                        _this2.mainViewLoaded = true;
                        _this2.update();
                    });
                }

                this.update();
            }
        }, {
            key: 'update',
            value: function update() {
                var state = _store2.default.getState();
                var props = {
                    pullRequest: this.pullRequest,
                    mergeCommit: this.mergeCommit,
                    path: this.path,
                    visible: this.visible,
                    mainViewLoaded: this.mainViewLoaded,
                    sideEffects: this
                };

                // NOTE: There is a problem with this implementation where a synchronously dispatched action
                // will recursively run the update() method and when it completes, the old update() method will finish running
                // using outdated state/props. This could cause bugs since we're relying on cached values to avoid rerunning side-effects.
                // This would definitely affect `toggleSpinner` if it wasn't first in the list, for example.
                // However:
                //   - the fix (aborting) seemed overcomplicated
                //   - we're planning to switch to real React/reactive programming soon with PR Usability (which would kill this code)
                //   - there's no bugs now
                // So I've left it at:
                // https://stash.dev.internal.atlassian.com/projects/STASH/repos/stash/commits/e74cd44ab5d3d2e9bd8b18f9d7987c283cfd4c53
                // If there is a regression in this update handling, consider applying that patch.
                renderInsightsButton(state, props);
                maybeLoadAnnotations(state, props);
                maybeLoadReports(state, props);
                renderAnnotations(state, props);
            }
        }, {
            key: 'attachAnnotations',
            value: function attachAnnotations(annotations, reportsByKey) {
                var _this3 = this;

                var activeAnnotations = annotations && annotations.filter(function (_ref2) {
                    var outdated = _ref2.outdated;
                    return !outdated;
                });

                // if we somehow have line annotations on a file that doesn't have the concept of lines, we show them as file annotations
                if (!this.isTextView) {
                    this.attachFileAnnotations(activeAnnotations, reportsByKey);
                    return;
                }

                var annotationsByLine = (0, _lodash.groupBy)(activeAnnotations, 'line');
                var fileAnnotations = annotationsByLine[0];
                delete annotationsByLine[0];

                this.mainView.operation(function () {
                    _this3.attachLineAnnotations(annotationsByLine, reportsByKey);
                    _this3.attachFileAnnotations(fileAnnotations, reportsByKey);
                });
            }
        }, {
            key: 'attachLineAnnotations',
            value: function attachLineAnnotations(annotationsByLine, reportsByKey) {
                for (var lineNumber in annotationsByLine) {
                    var lineAnnotations = annotationsByLine[lineNumber];
                    var existing = this.annotationContainersByLine[lineNumber];
                    if (existing) {
                        renderReactAnnotationRoot(lineAnnotations, reportsByKey, existing.el);
                        existing.widget.changed();
                        continue;
                    }
                    var lineHandle = this.mainView.getLineHandle({
                        lineType: 'ADDED',
                        fileType: 'TO',
                        lineNumber: lineAnnotations[0].line
                    });

                    if (lineHandle) {
                        var el = document.createElement('div');
                        el.className = 'annotation-line-widget';

                        renderReactAnnotationRoot(lineAnnotations, reportsByKey, el);

                        var widget = this.mainView.addLineWidget(lineHandle, el, {
                            weight: 50,
                            noHScroll: true,
                            coverGutter: true
                        });

                        this.annotationContainersByLine[lineNumber] = {
                            el: el,
                            widget: widget
                        };
                    }
                    // else ignore whitespace is probably on and it's messing up the diff.
                    // Either an ADDED line rendered as CONTEXT or the whole hunk was removed from a unified diff.
                }
                for (var _lineNumber in this.annotationContainersByLine) {
                    if (!(_lineNumber in annotationsByLine)) {
                        var _existing = this.annotationContainersByLine[_lineNumber];
                        _reactDom2.default.unmountComponentAtNode(_existing.el);
                        _existing.widget.clear();
                        delete this.annotationContainersByLine[_lineNumber];
                    }
                }
            }
        }, {
            key: 'attachFileAnnotations',
            value: function attachFileAnnotations(annotations, reportsByKey) {
                var existing = this.fileAnnotationContainer;
                if (!annotations) {
                    if (existing) {
                        _reactDom2.default.unmountComponentAtNode(existing.el);
                        this.fileAnnotationContainer = null;
                    } else {
                        return; // no need to refresh the textview, no change
                    }
                } else if (existing) {
                    renderReactAnnotationRoot(annotations, reportsByKey, existing.el);
                } else {
                    var containerId = 'file-annotations-container';
                    this.$container.prepend('<div id="' + containerId + '" class="' + containerId + '" />');
                    var containerEl = document.getElementById(containerId);
                    renderReactAnnotationRoot(annotations, reportsByKey, containerEl);
                    this.fileAnnotationContainer = {
                        el: containerEl
                    };
                }

                if (this.mainView.refresh) {
                    this.mainView.refresh();
                }
            }
        }, {
            key: 'setVisible',
            value: function setVisible(visible) {
                this.visible = visible;
                this.update();
            }
        }]);
        return DiffAnnotations;
    }(_widget2.default);

    exports.default = DiffAnnotations;
    module.exports = exports['default'];
});