define('bitbucket-plugin-code-insights/internal/outdated-annotations/outdated-annotations', ['module', 'exports', '@atlassian/aui', 'lodash', 'react', 'bitbucket/internal/bbui/aui-react/dialog', 'bitbucket/internal/bbui/aui-react/inline-dialog', '../analytics', '../annotation-table/annotation-table'], function (module, exports, _aui, _lodash, _react, _dialog, _inlineDialog, _analytics, _annotationTable) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = babelHelpers.interopRequireDefault(_react);

    var _dialog2 = babelHelpers.interopRequireDefault(_dialog);

    var _inlineDialog2 = babelHelpers.interopRequireDefault(_inlineDialog);

    var _analytics2 = babelHelpers.interopRequireDefault(_analytics);

    var _annotationTable2 = babelHelpers.interopRequireDefault(_annotationTable);

    var OutdatedAnnotations = function (_Component) {
        babelHelpers.inherits(OutdatedAnnotations, _Component);

        function OutdatedAnnotations() {
            var _ref;

            var _temp, _this, _ret;

            babelHelpers.classCallCheck(this, OutdatedAnnotations);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = babelHelpers.possibleConstructorReturn(this, (_ref = OutdatedAnnotations.__proto__ || Object.getPrototypeOf(OutdatedAnnotations)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
                dialogOpen: false
            }, _this.showOutdatedDialog = function (e) {
                var _this$props = _this.props,
                    annotations = _this$props.annotations,
                    reportsByKey = _this$props.reportsByKey;

                _this.setState({ dialogOpen: true });
                (0, _analytics2.default)('stash.client.codeinsights.pullrequest.diff.outdated.dialog.opened', {
                    'annotations.count': annotations.length,
                    'report.count': Object.keys(reportsByKey).length
                });
            }, _this.onCloseDialog = function () {
                _this.setState({ dialogOpen: false });
            }, _temp), babelHelpers.possibleConstructorReturn(_this, _ret);
        }

        babelHelpers.createClass(OutdatedAnnotations, [{
            key: 'componentWillMount',
            value: function componentWillMount() {
                this.inlineDialog = document.getElementById(this.props.infoDialogId);
            }
        }, {
            key: 'componentDidMount',
            value: function componentDidMount() {
                var _this2 = this;

                this.inlineDialog = document.getElementById(this.props.infoDialogId);
                (0, _lodash.defer)(function () {
                    if (_this2.props.showInfoDialog) {
                        _this2.inlineDialog.open = true;
                    }
                });
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate() {
                if (this.state.dialogOpen) {
                    this.inlineDialog.open = false;
                }
            }
        }, {
            key: 'componentWillUnmount',
            value: function componentWillUnmount() {
                this.inlineDialog.parentNode.removeChild(this.inlineDialog);
            }
        }, {
            key: 'render',
            value: function render() {
                var _props = this.props,
                    annotations = _props.annotations,
                    reportsByKey = _props.reportsByKey,
                    infoDialogId = _props.infoDialogId,
                    pullRequest = _props.pullRequest;

                var fileName = annotations[0].path;
                return _react2.default.createElement(
                    _react.Fragment,
                    null,
                    _react2.default.createElement(
                        _inlineDialog2.default,
                        {
                            id: infoDialogId,
                            className: infoDialogId + ' outdated-annotations-warning',
                            alignment: 'bottom center'
                        },
                        _react2.default.createElement(
                            'h5',
                            null,
                            _aui.I18n.getText('bitbucket.codeinsights.annotation.outdated.info.title')
                        ),
                        _react2.default.createElement(
                            'p',
                            { className: 'warning' },
                            _aui.I18n.getText('bitbucket.codeinsights.annotation.outdated.info.content'),
                            ' ',
                            _react2.default.createElement(
                                'a',
                                {
                                    href: bitbucket_help_url('bitbucket.go.code.insights.outdated.learn.more'),
                                    target: '_blank'
                                },
                                _aui.I18n.getText('bitbucket.codeinsights.annotation.outdated.info.learn.more')
                            )
                        ),
                        _react2.default.createElement(
                            'p',
                            { className: 'actions' },
                            _react2.default.createElement(
                                'button',
                                {
                                    className: 'aui-button see-outdated-annotations',
                                    onClick: this.showOutdatedDialog
                                },
                                _aui.I18n.getText('bitbucket.codeinsights.annotation.outdated.info.see.outdated')
                            )
                        )
                    ),
                    this.state.dialogOpen && _react2.default.createElement(
                        _dialog2.default,
                        {
                            onClose: this.onCloseDialog,
                            size: _dialog.DialogSize.XLARGE,
                            titleContent: _aui.I18n.getText('bitbucket.codeinsights.annotation.outdated.title'),
                            className: 'outdated-annotations-dialog'
                        },
                        _react2.default.createElement(
                            'p',
                            null,
                            _aui.I18n.getText('bitbucket.codeinsights.annotation.outdated.analysis.before', fileName)
                        ),
                        _react2.default.createElement(_annotationTable2.default, {
                            annotations: annotations,
                            pullRequest: pullRequest,
                            reportsByKey: reportsByKey,
                            Columns: [_annotationTable.ReporterColumn, _annotationTable.SeverityColumn, _annotationTable.TypeColumn, _annotationTable.MessageColumn, _annotationTable.LineColumn]
                        })
                    )
                );
            }
        }]);
        return OutdatedAnnotations;
    }(_react.Component);

    exports.default = OutdatedAnnotations;
    module.exports = exports['default'];
});