define('bitbucket-plugin-code-insights/internal/list-and-detail/list-and-detail', ['module', 'exports', 'prop-types', 'react', 'bitbucket/internal/util/components/react-functional', 'bitbucket/internal/util/get-id'], function (module, exports, _propTypes, _react, _reactFunctional, _getId) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _propTypes2 = babelHelpers.interopRequireDefault(_propTypes);

    var _react2 = babelHelpers.interopRequireDefault(_react);

    var DefaultMenuItem = (0, _reactFunctional.pure)(function (_ref) {
        var title = _ref.item.title;
        return title;
    });

    var Item = function (_PureComponent) {
        babelHelpers.inherits(Item, _PureComponent);

        function Item() {
            var _ref2;

            var _temp, _this, _ret;

            babelHelpers.classCallCheck(this, Item);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = babelHelpers.possibleConstructorReturn(this, (_ref2 = Item.__proto__ || Object.getPrototypeOf(Item)).call.apply(_ref2, [this].concat(args))), _this), _this.onClick = function (e) {
                e.preventDefault();
                _this.props.onClick(_this.props.item);
            }, _temp), babelHelpers.possibleConstructorReturn(_this, _ret);
        }

        babelHelpers.createClass(Item, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    selected = _props.selected,
                    item = _props.item,
                    menuItem = _props.menuItem;

                return _react2.default.createElement(
                    'li',
                    { className: selected ? 'selected' : null },
                    _react2.default.createElement(
                        'button',
                        { type: 'button', onClick: this.onClick },
                        menuItem({ item: item })
                    )
                );
            }
        }]);
        return Item;
    }(_react.PureComponent);

    var ListAndDetailView = function (_PureComponent2) {
        babelHelpers.inherits(ListAndDetailView, _PureComponent2);

        function ListAndDetailView() {
            var _ref3;

            var _temp2, _this2, _ret2;

            babelHelpers.classCallCheck(this, ListAndDetailView);

            for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                args[_key2] = arguments[_key2];
            }

            return _ret2 = (_temp2 = (_this2 = babelHelpers.possibleConstructorReturn(this, (_ref3 = ListAndDetailView.__proto__ || Object.getPrototypeOf(ListAndDetailView)).call.apply(_ref3, [this].concat(args))), _this2), _this2.state = {}, _this2.onItemSelected = function (selectedItem) {
                _this2.setState({
                    selectedId: (0, _getId.getId)(_this2.props.idKey)(selectedItem)
                });
            }, _temp2), babelHelpers.possibleConstructorReturn(_this2, _ret2);
        }

        babelHelpers.createClass(ListAndDetailView, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                this.notifyThatItemWasSelected();
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate(prevProps, prevState) {
                if (prevState.selectedId !== this.state.selectedId) {
                    this.notifyThatItemWasSelected();
                }
            }
        }, {
            key: 'notifyThatItemWasSelected',
            value: function notifyThatItemWasSelected() {
                var _this3 = this;

                var _props2 = this.props,
                    items = _props2.items,
                    idKey = _props2.idKey,
                    onItemSelected = _props2.onItemSelected;

                if (onItemSelected) {
                    var getId = (0, _getId.getId)(idKey);
                    var selectedItem = items.find(function (item) {
                        return getId(item) === _this3.state.selectedId;
                    });

                    this.props.onItemSelected(selectedItem);
                }
            }
        }, {
            key: 'render',
            value: function render() {
                var _this4 = this;

                var _props3 = this.props,
                    items = _props3.items,
                    idKey = _props3.idKey,
                    _props3$menuItem = _props3.menuItem,
                    menuItem = _props3$menuItem === undefined ? DefaultMenuItem : _props3$menuItem,
                    detail = _props3.detail;
                var selectedId = this.state.selectedId;

                var getId = (0, _getId.getId)(idKey);
                var selectedItem = void 0;
                var selectedItemIndex = void 0;
                return _react2.default.createElement(
                    'div',
                    { className: 'list-and-detail' },
                    _react2.default.createElement(
                        'ul',
                        { className: 'list' },
                        items.map(function (item, index) {
                            var id = getId(item);
                            var isSelected = id === selectedId;
                            if (isSelected) {
                                selectedItem = item;
                                selectedItemIndex = index;
                            }
                            return _react2.default.createElement(Item, {
                                key: id,
                                selected: isSelected,
                                item: item,
                                menuItem: menuItem,
                                onClick: _this4.onItemSelected
                            });
                        })
                    ),
                    _react2.default.createElement(
                        'section',
                        { className: 'detail' },
                        selectedItem && detail({ item: selectedItem, index: selectedItemIndex })
                    )
                );
            }
        }], [{
            key: 'getDerivedStateFromProps',
            value: function getDerivedStateFromProps(_ref4, _ref5) {
                var items = _ref4.items,
                    idKey = _ref4.idKey;
                var selectedId = _ref5.selectedId;

                var getId = (0, _getId.getId)(idKey);
                var selectedItem = selectedId && items.find(function (item) {
                    return getId(item) === selectedId;
                });
                if (!selectedItem && items && items.length) {
                    return {
                        selectedId: getId(items[0])
                    };
                }
                return null;
            }
        }]);
        return ListAndDetailView;
    }(_react.PureComponent);

    ListAndDetailView.propTypes = {
        onItemSelected: _propTypes2.default.func,
        items: _propTypes2.default.array.isRequired,
        menuItem: _propTypes2.default.func.isRequired,
        detail: _propTypes2.default.func.isRequired
    };
    ListAndDetailView.defaultProps = {
        idKey: 'id'
    };
    exports.default = ListAndDetailView;
    module.exports = exports['default'];
});