define('bitbucket-plugin-code-insights/internal/insight-preferences', ['exports', 'lodash', 'bitbucket/internal/util/client-storage'], function (exports, _lodash, _clientStorage) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.toggleAnnotationVisibilitySetting = toggleAnnotationVisibilitySetting;
    exports.getAnnotationVisibilitySetting = getAnnotationVisibilitySetting;

    var _clientStorage2 = babelHelpers.interopRequireDefault(_clientStorage);

    // only initialize the storageKey when required
    var storageKey = (0, _lodash.once)(function () {
        return _clientStorage2.default.buildKey(['text-view', 'code-insights-options'], 'user');
    });

    var defaultOptions = {
        visible: true
    };

    /**
     * Toggle the annotation visibility setting
     * @param {boolean} visible
     */
    function toggleAnnotationVisibilitySetting(visible) {
        _clientStorage2.default.setItem(storageKey(), { visible: visible });
    }

    /**
     * Get the annotation visibility setting
     * @returns {boolean}
     */
    function getAnnotationVisibilitySetting() {
        return babelHelpers.extends({}, defaultOptions, _clientStorage2.default.getItem(storageKey())).visible;
    }
});