define('bitbucket-plugin-code-insights/internal/feature-discovery/feature-discovery', ['exports', '@atlassian/aui', 'chaperone', 'jquery', 'bitbucket/internal/util/user-created-version', '../analytics'], function (exports, _aui, _chaperone, _jquery, _userCreatedVersion, _analytics) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.initialFeatureDiscovery = initialFeatureDiscovery;
    exports.firstUseFeatureDiscovery = firstUseFeatureDiscovery;

    var _chaperone2 = babelHelpers.interopRequireDefault(_chaperone);

    var _jquery2 = babelHelpers.interopRequireDefault(_jquery);

    var _analytics2 = babelHelpers.interopRequireDefault(_analytics);

    var FEATURE_VERSION = '5.15.0';

    function featureDiscovery(_ref) {
        var id = _ref.id,
            selector = _ref.selector,
            title = _ref.title,
            content = _ref.content,
            text = _ref.linkText,
            href = _ref.linkHref;

        // if the current user was created after this feature was released, don't show onboarding
        if (!(0, _userCreatedVersion.userCreatedBefore)(FEATURE_VERSION)) {
            return;
        }

        _chaperone2.default.registerFeature(id, [{
            id: 'code-insights-discovery-' + id,
            selector: selector,
            extraClasses: 'code-insights-feature-discovery ' + id,
            alignment: 'left top',
            title: title,
            persistent: false,
            content: content,
            action: {
                href: href,
                text: text,
                type: 'primary',
                extraAttributes: {
                    target: '_blank'
                }
            },
            close: {
                text: _aui.I18n.getText('bitbucket.web.button.dismiss')
            },
            width: 340
        }]);
    }

    function initialFeatureDiscovery() {
        var title = _aui.I18n.getText('bitbucket.codeinsights.feature.discovery.initial.intro.title');
        var content = '\n        <p>' + _aui.I18n.getText('bitbucket.codeinsights.feature.discovery.initial.intro.1') + '</p>\n        <p>' + _aui.I18n.getText('bitbucket.codeinsights.feature.discovery.initial.intro.2') + '</p>\n        <p class="create-own-cta">' + _aui.I18n.getText('bitbucket.codeinsights.feature.discovery.initial.intro.3.html', bitbucket_help_url('bitbucket.go.code.insights.create.own')) + '</p>';

        featureDiscovery({
            id: 'code-insights-initial',
            selector: '.plugin-item.learn-more',
            title: title,
            content: content,
            linkText: _aui.I18n.getText('bitbucket.codeinsights.feature.discovery.initial.button.find'),
            linkHref: bitbucket_help_url('bitbucket.go.code.insights.find.integrations')
        });

        (0, _jquery2.default)(document).on('click', '.code-insights-initial .create-own-cta a', function () {
            (0, _analytics2.default)('stash.client.codeinsights.onboarding.initial.cta.clicked');
        }).on('click', '.code-insights-initial .feature-discovery-action', function () {
            (0, _analytics2.default)('stash.client.codeinsights.onboarding.initial.link.clicked');
        });
    }

    function firstUseFeatureDiscovery() {
        var title = _aui.I18n.getText('bitbucket.codeinsights.feature.discovery.first.use.title');
        var content = '<p>' + _aui.I18n.getText('bitbucket.codeinsights.feature.discovery.first.use.content') + '</p>';

        featureDiscovery({
            id: 'code-insights-first-use',
            selector: '.plugin-item.code-insights-overview',
            title: title,
            content: content,
            linkText: _aui.I18n.getText('bitbucket.codeinsights.feature.discovery.first.use.learn.more'),
            linkHref: bitbucket_help_url('bitbucket.go.code.insights.learn.more')
        });
        // once the first use has been seen, there is no need to also show the initial introduction, so mark it as seen.
        _chaperone2.default._internal.syncing.syncToServer('code-insights-initial', { isAllDismissed: true });

        (0, _jquery2.default)(document).on('click', '.code-insights-first-use .feature-discovery-action', function () {
            (0, _analytics2.default)('stash.client.codeinsights.onboarding.firstuse.link.clicked');
        });
    }
});