define('bitbucket-plugin-code-insights/internal/annotation-table/annotation-table', ['exports', '@atlassian/aui', 'classnames', 'react', 'bitbucket/util/navbuilder', 'bitbucket/internal/bbui/tipsy/tipsy', 'bitbucket/internal/widget/conditional-link', 'bitbucket/internal/widget/icons/icons', '../annotation/annotation', './reporter-logo'], function (exports, _aui, _classnames, _react, _navbuilder, _tipsy, _conditionalLink, _icons, _annotation, _reporterLogo) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.ReporterColumn = exports.LineColumn = exports.FileColumn = exports.MessageColumn = exports.TypeColumn = exports.SeverityColumn = undefined;

    var _classnames2 = babelHelpers.interopRequireDefault(_classnames);

    var _react2 = babelHelpers.interopRequireDefault(_react);

    var _navbuilder2 = babelHelpers.interopRequireDefault(_navbuilder);

    var _tipsy2 = babelHelpers.interopRequireDefault(_tipsy);

    var _conditionalLink2 = babelHelpers.interopRequireDefault(_conditionalLink);

    var _reporterLogo2 = babelHelpers.interopRequireDefault(_reporterLogo);

    var TOOLTIP_DELAY = 500;

    var SeverityColumn = exports.SeverityColumn = function SeverityColumn(_ref) {
        var severity = _ref.severity;
        return _react2.default.createElement(
            'span',
            { className: 'severity-' + severity },
            _react2.default.createElement(_annotation.SeverityIcon, { severity: severity }),
            _react2.default.createElement(_annotation.SeverityLevel, { severity: severity })
        );
    };
    SeverityColumn.Header = function () {
        return _aui.I18n.getText('bitbucket.codeinsights.annotation.header.severity');
    };
    SeverityColumn.id = 'severity-column';

    var TypeColumn = exports.TypeColumn = function TypeColumn(_ref2) {
        var type = _ref2.type;
        return _react2.default.createElement(_annotation.AnnotationType, { type: type });
    };
    TypeColumn.Header = function () {
        return _aui.I18n.getText('bitbucket.codeinsights.annotation.header.type');
    };
    TypeColumn.id = 'type-column';

    var MessageColumn = exports.MessageColumn = function MessageColumn(_ref3) {
        var message = _ref3.message;
        return _react2.default.createElement(
            _tipsy2.default,
            {
                tooltipClassName: 'insights-message-tooltip',
                title: message,
                delay: TOOLTIP_DELAY,
                hoverable: false,
                condition: _tipsy2.default.isTruncatedCondition
            },
            message
        );
    };
    MessageColumn.Header = function () {
        return _aui.I18n.getText('bitbucket.codeinsights.annotation.header.message');
    };
    MessageColumn.id = 'message-column';

    var FileColumn = exports.FileColumn = function FileColumn(_ref4) {
        var path = _ref4.path,
            line = _ref4.line,
            pullRequest = _ref4.pullRequest,
            onClick = _ref4.onClick,
            outdated = _ref4.outdated;

        var pathComponents = path.split('/');
        var filename = pathComponents.pop();
        var params = {};
        var tipsyTitle = filename;
        var tipsyCondition = void 0;

        if (outdated) {
            params.outdated = true;
            tipsyTitle = _aui.I18n.getText('bitbucket.codeinsights.annotation.outdated.description');
        } else {
            // if a filename is truncated that's when we will show it in a tooltip
            tipsyCondition = function tipsyCondition(el) {
                return _tipsy2.default.isTruncatedCondition(el.querySelector('.file-name'));
            };
        }

        var href = _navbuilder2.default.pullRequest(pullRequest).diff().withParams(params).change(path + (line && !outdated ? '?T' + line : '')).build();

        var content = _react2.default.createElement(
            _react.Fragment,
            null,
            _react2.default.createElement(
                'span',
                { className: 'file-name' },
                filename
            ),
            line ? _react2.default.createElement(
                _react.Fragment,
                null,
                _react2.default.createElement(
                    'span',
                    { className: 'separator' },
                    ':'
                ),
                _react2.default.createElement(
                    'span',
                    { className: 'line-number' },
                    line
                )
            ) : null
        );

        return _react2.default.createElement(
            'a',
            { href: href, onClick: onClick, className: 'file-name-inner' },
            _react2.default.createElement(
                _tipsy2.default,
                {
                    title: tipsyTitle,
                    hoverable: false,
                    delay: TOOLTIP_DELAY,
                    className: 'location',
                    condition: tipsyCondition
                },
                content
            )
        );
    };
    FileColumn.Header = function () {
        return _aui.I18n.getText('bitbucket.codeinsights.annotation.header.file');
    };
    FileColumn.id = 'file-column';

    var LineColumn = exports.LineColumn = function LineColumn(_ref5) {
        var line = _ref5.line;
        return line !== 0 ? line : null;
    };
    LineColumn.Header = function () {
        return _aui.I18n.getText('bitbucket.codeinsights.annotation.header.line');
    };
    LineColumn.id = 'line-column';

    var ReporterColumn = exports.ReporterColumn = function ReporterColumn(_ref6) {
        var report = _ref6.report,
            link = _ref6.link;

        if (!report) {
            return null;
        }

        var name = report.reporter || report.title;

        return _react2.default.createElement(
            _conditionalLink2.default,
            {
                href: link,
                className: 'reporter-link',
                target: '_blank',
                rel: 'noreferrer noopener'
            },
            _react2.default.createElement(_reporterLogo2.default, { report: report }),
            _react2.default.createElement(
                'span',
                { className: 'report-title' },
                name
            )
        );
    };
    ReporterColumn.Header = function () {
        return _aui.I18n.getText('bitbucket.codeinsights.annotation.header.reporter');
    };
    ReporterColumn.id = 'reporter-column';

    var defaultColumns = [SeverityColumn, MessageColumn, FileColumn];

    var AnnotationTable = function (_PureComponent) {
        babelHelpers.inherits(AnnotationTable, _PureComponent);

        function AnnotationTable() {
            var _ref7;

            var _temp, _this, _ret;

            babelHelpers.classCallCheck(this, AnnotationTable);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = babelHelpers.possibleConstructorReturn(this, (_ref7 = AnnotationTable.__proto__ || Object.getPrototypeOf(AnnotationTable)).call.apply(_ref7, [this].concat(args))), _this), _this.state = {}, _temp), babelHelpers.possibleConstructorReturn(_this, _ret);
        }

        babelHelpers.createClass(AnnotationTable, [{
            key: 'render',
            value: function render() {
                var _this2 = this;

                var _props = this.props,
                    annotations = _props.annotations,
                    reportsByKey = _props.reportsByKey,
                    pullRequest = _props.pullRequest,
                    _props$Columns = _props.Columns,
                    Columns = _props$Columns === undefined ? defaultColumns : _props$Columns,
                    onFileClick = _props.onFileClick;
                var _state$tooltipsEnable = this.state.tooltipsEnabled,
                    tooltipsEnabled = _state$tooltipsEnable === undefined ? true : _state$tooltipsEnable;


                if (!annotations || annotations.length === 0) {
                    return null;
                }
                return _react2.default.createElement(
                    'table',
                    {
                        className: (0, _classnames2.default)('aui report-annotation-table', {
                            'no-tooltips': !tooltipsEnabled
                        })
                    },
                    _react2.default.createElement(
                        'thead',
                        null,
                        _react2.default.createElement(
                            'tr',
                            null,
                            Columns.map(function (Col) {
                                return _react2.default.createElement(
                                    'th',
                                    { key: Col.id, scope: 'col', className: Col.id },
                                    _react2.default.createElement(Col.Header, null)
                                );
                            })
                        )
                    ),
                    _react2.default.createElement(
                        'tbody',
                        null,
                        annotations.map(function (annotation) {
                            var report = _this2.props.report || reportsByKey[annotation.reportKey];
                            return _react2.default.createElement(
                                'tr',
                                {
                                    key: report.key + '/' + annotation.id,
                                    className: annotation.outdated ? 'outdated' : null
                                },
                                Columns.map(function (Col) {
                                    return _react2.default.createElement(
                                        'td',
                                        { key: Col.id, className: Col.id },
                                        Col === FileColumn ? _react2.default.createElement(Col, babelHelpers.extends({}, annotation, {
                                            pullRequest: pullRequest,
                                            onClick: function onClick(e) {
                                                return onFileClick(e, annotation);
                                            }
                                        })) : _react2.default.createElement(Col, babelHelpers.extends({}, annotation, {
                                            report: report,
                                            pullRequest: pullRequest
                                        }))
                                    );
                                })
                            );
                        })
                    )
                );
            }
        }]);
        return AnnotationTable;
    }(_react.PureComponent);

    exports.default = AnnotationTable;
});