/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.rest;

import com.atlassian.bitbucket.codeinsights.report.InsightReportData;
import com.atlassian.bitbucket.rest.RestMapEntity;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.NotBlank;

public class RestInsightReportData
extends RestMapEntity {
    private static final String TITLE = "title";
    private static final String TYPE = "type";
    private static final String VALUE = "value";

    public RestInsightReportData() {
    }

    private RestInsightReportData(Map<String, Object> map) {
        super(map);
    }

    public RestInsightReportData(InsightReportData data) {
        this.put(TITLE, data.getTitle());
        this.put(VALUE, data.getValue());
        if (data.getType() != null) {
            this.put(TYPE, data.getType().name());
        }
    }

    @NotBlank(message="{bitbucket.rest.codeinsights.error.data.title.required}")
    public String getTitle() {
        return this.getStringProperty(TITLE);
    }

    @Pattern(message="{bitbucket.rest.codeinsights.error.data.type.pattern}", regexp="BOOLEAN|DATE|DURATION|LINK|NUMBER|PERCENTAGE|TEXT")
    public String getType() {
        return this.getStringProperty(TYPE);
    }

    @NotNull(message="{bitbucket.rest.codeinsights.error.data.value.required}")
    public Object getValue() {
        return this.get(VALUE);
    }

    public static RestInsightReportData valueOf(Object value) {
        if (value instanceof RestInsightReportData) {
            return (RestInsightReportData)((Object)value);
        }
        if (value instanceof Map) {
            return new RestInsightReportData((Map)value);
        }
        if (value instanceof InsightReportData) {
            return new RestInsightReportData((InsightReportData)value);
        }
        return null;
    }
}

