/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.rest;

import com.atlassian.bitbucket.codeinsights.annotation.AnnotationSeverity;
import com.atlassian.bitbucket.codeinsights.annotation.AnnotationType;
import com.atlassian.bitbucket.codeinsights.annotation.InsightAnnotation;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestInsightReport;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.pull.RestPullRequest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import java.util.Optional;

public class RestInsightAnnotation
extends RestMapEntity {
    public static final String REPORT_KEY = "reportKey";
    public static final String EFFECTIVE_PATH = "effectivePath";
    public static final String EXTERNAL_ID = "externalId";
    public static final String LINE = "line";
    public static final String LINK = "link";
    public static final String MESSAGE = "message";
    public static final String PATH = "path";
    public static final String SEVERITY = "severity";
    public static final String OUTDATED = "outdated";
    public static final RestInsightAnnotation EXAMPLE = new RestInsightAnnotation(RestInsightReport.EXAMPLE.getKey(), Optional.of("external.id"), 5, Optional.of(URI.create("http://example.com/my/file/analysis?line=5")), "This is an annotation message", "src/some/structure/file.ext", AnnotationSeverity.HIGH, Optional.of(AnnotationType.BUG));
    public static final Map<String, Object> EXAMPLE_STREAM = ImmutableMap.of((Object)"annotations", (Object)ImmutableList.of((Object)((Object)EXAMPLE)));
    public static final Map<String, Object> EXAMPLE_PULL_REQUEST_STREAM = ImmutableMap.of((Object)"annotations", (Object)ImmutableList.of((Object)((Object)EXAMPLE)), (Object)"pullRequest", (Object)RestPullRequest.RESPONSE_EXAMPLE);

    public RestInsightAnnotation() {
    }

    public RestInsightAnnotation(String reportKey, Optional<String> externalId, Integer line, Optional<URI> deeplink, String message, String path, AnnotationSeverity severity, Optional<AnnotationType> type) {
        this(reportKey, externalId, line, deeplink, message, false, path, severity, type);
    }

    public RestInsightAnnotation(String reportKey, Optional<String> externalId, Integer line, Optional<URI> deeplink, String message, boolean outdated, String path, AnnotationSeverity severity, Optional<AnnotationType> type) {
        this.put(REPORT_KEY, reportKey);
        externalId.ifPresent(id -> this.put(EXTERNAL_ID, id));
        this.putIfNotNull(LINE, line);
        deeplink.ifPresent(link -> this.put(LINK, link.toASCIIString()));
        this.put(MESSAGE, message);
        if (outdated) {
            this.put(OUTDATED, outdated);
        }
        this.put(PATH, path);
        this.put(SEVERITY, severity.toString());
        type.ifPresent(t -> this.put("type", t.toString()));
    }

    public RestInsightAnnotation(InsightAnnotation annotation) {
        this(annotation.getReportKey(), annotation.getExternalId(), annotation.getLine(), annotation.getLink(), annotation.getMessage(), annotation.isOutdated(), annotation.getPath(), annotation.getSeverity(), annotation.getType());
    }
}

