/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.codeinsights.annotation.AnnotationSeverity;
import com.atlassian.bitbucket.codeinsights.annotation.AnnotationType;
import com.atlassian.bitbucket.internal.codeinsights.annotation.ModifiedFile;
import com.atlassian.bitbucket.internal.codeinsights.dao.AoInsightAnnotation;
import com.atlassian.bitbucket.internal.codeinsights.dao.AoInsightReport;
import com.atlassian.bitbucket.internal.codeinsights.dao.InsightAnnotationDao;
import com.atlassian.bitbucket.internal.codeinsights.dao.InternalInsightAnnotation;
import com.atlassian.bitbucket.ssh.StandardDigests;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.google.common.collect.Iterables;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AoInsightAnnotationDao
extends AbstractAoDao
implements InsightAnnotationDao {
    private static final int PARTITION_SIZE = 100;
    private static final Logger log = LoggerFactory.getLogger(AoInsightAnnotationDao.class);

    public AoInsightAnnotationDao(ActiveObjects activeObjects) {
        super(activeObjects);
    }

    @Override
    public int countForCommit(int repositoryId, @Nonnull String commitId) {
        Query query = Query.select().alias(AoInsightAnnotation.class, "annotation").alias(AoInsightReport.class, "report").join(AoInsightReport.class, "report.ID=annotation.FK_REPORT_ID");
        String whereClause = "report." + "REPOSITORY_ID" + " = ?" + " AND " + "report." + "COMMIT_ID" + " = ? ";
        query.where(whereClause, new Object[]{repositoryId, commitId});
        return this.ao.count(AoInsightAnnotation.class, query);
    }

    @Override
    public int countForReport(long id) {
        return this.ao.count(AoInsightAnnotation.class, Query.select().where("FK_REPORT_ID = ?", new Object[]{id}));
    }

    @Override
    public void create(long reportId, @Nullable String externalId, int line, @Nullable String link, @Nonnull String message, @Nonnull String path, @Nonnull AnnotationSeverity severity, @Nullable AnnotationType type) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("EXTERNAL_ID", externalId);
        properties.put("FK_REPORT_ID", reportId);
        properties.put("LINE", line);
        properties.put("LINK", link);
        properties.put("MESSAGE", message);
        properties.put("PATH", path);
        properties.put("PATH_MD5", AoInsightAnnotationDao.md5(path));
        properties.put("SEVERITY_ID", severity.getId());
        properties.put("TYPE_ID", type == null ? null : Integer.valueOf(type.getId()));
        this.ao.create(AoInsightAnnotation.class, properties);
    }

    @Override
    public boolean delete(long id) {
        return this.ao.deleteWithSQL(AoInsightAnnotation.class, "ID = ?", new Object[]{id}) > 0;
    }

    @Override
    public int deleteByReportAndExternalIds(long reportId, @Nonnull Collection<String> externalIds) {
        if (externalIds.isEmpty()) {
            return this.ao.deleteWithSQL(AoInsightAnnotation.class, String.format("%s = ?", "FK_REPORT_ID"), new Object[]{reportId});
        }
        return MoreStreams.streamIterable((Iterable)Iterables.partition(externalIds, (int)100)).mapToInt(ids -> this.ao.deleteWithSQL(AoInsightAnnotation.class, String.format("%s = ? AND %s IN (%s)", "FK_REPORT_ID", "EXTERNAL_ID", StringUtils.repeat((String)"?", (String)",", (int)ids.size())), Stream.concat(Stream.of(Long.valueOf(reportId)), ids.stream()).toArray())).sum();
    }

    @Override
    public int deleteForReport(Long ... reportId) {
        if (reportId.length == 0) {
            return 0;
        }
        return this.ao.deleteWithSQL(AoInsightAnnotation.class, "FK_REPORT_ID IN (" + StringUtils.repeat((String)"?", (String)",", (int)reportId.length) + ')', (Object[])reportId);
    }

    @Override
    @Nonnull
    public Optional<InternalInsightAnnotation> getByExternalId(long reportId, @Nonnull String externalId) {
        String whereClause = String.format("%s = ? AND %s = ?", "FK_REPORT_ID", "EXTERNAL_ID");
        AoInsightAnnotation[] annotations = (AoInsightAnnotation[])this.ao.find(AoInsightAnnotation.class, Query.select().where(whereClause, new Object[]{reportId, externalId}));
        if (annotations.length > 1) {
            log.warn("Multiple annotations found for report with ID '{}' and annotation with external ID '{}'", (Object)reportId, (Object)externalId);
        }
        return annotations.length > 0 ? Optional.of(annotations[0]) : Optional.empty();
    }

    @Override
    public boolean hasAnnotations(long reportID, @Nonnull Collection<String> externalIds) {
        return MoreStreams.streamIterable((Iterable)Iterables.partition(externalIds, (int)100)).anyMatch(ids -> {
            String whereClause = String.format("%s = ? AND %s IN (%s)", "FK_REPORT_ID", "EXTERNAL_ID", StringUtils.repeat((String)"?", (String)", ", (int)ids.size()));
            Object[] values = new Object[ids.size() + 1];
            values[0] = reportID;
            System.arraycopy(ids.toArray(), 0, values, 1, values.length - 1);
            return this.ao.count(AoInsightAnnotation.class, Query.select().where(whereClause, values)) != 0;
        });
    }

    @Override
    @Nonnull
    public Page<InternalInsightAnnotation> search(int repositoryId, @Nonnull String commitId, @Nonnull Collection<String> reportKeys, @Nonnull Collection<String> externalIds, @Nonnull Collection<ModifiedFile> modifiedFiles, @Nonnull Collection<AnnotationSeverity> severities, @Nonnull Collection<AnnotationType> types, @Nonnull PageRequest pageRequest) {
        Query query = Query.select().alias(AoInsightAnnotation.class, "annotation").alias(AoInsightReport.class, "report").join(AoInsightReport.class, "report.ID=annotation.FK_REPORT_ID");
        StringBuilder whereClause = new StringBuilder().append("report.").append("REPOSITORY_ID").append(" = ?").append(" AND ").append("report.").append("COMMIT_ID").append(" = ? ");
        Object[] arguments = Stream.of(Stream.of(Integer.valueOf(repositoryId)), Stream.of(commitId), AoInsightAnnotationDao.maybeFilterByReports(whereClause, reportKeys), AoInsightAnnotationDao.maybeFilterByExternalIds(whereClause, externalIds), AoInsightAnnotationDao.maybeFilterByPaths(whereClause, modifiedFiles), AoInsightAnnotationDao.maybeFilterBySeverities(whereClause, severities), AoInsightAnnotationDao.maybeFilterByTypes(whereClause, types)).flatMap(Function.identity()).toArray();
        query = query.where(whereClause.toString(), arguments);
        return PageUtils.asPageOf(InternalInsightAnnotation.class, (Page)this.pageQuery(AoInsightAnnotation.class, query.order("SEVERITY_ID DESC, LINE ASC"), pageRequest));
    }

    private static void filterAnnotations(StringBuilder builder, String alias, String field, int size) {
        builder.append(" AND ").append(alias).append('.').append(field).append(" IN (").append(StringUtils.repeat((String)"?", (String)",", (int)size)).append(") ");
    }

    private static Stream<String> maybeFilterByExternalIds(StringBuilder builder, Collection<String> externalIds) {
        if (externalIds.isEmpty()) {
            return Stream.empty();
        }
        AoInsightAnnotationDao.filterAnnotations(builder, "annotation", "EXTERNAL_ID", externalIds.size());
        return externalIds.stream();
    }

    private static Stream<Object> maybeFilterByPaths(StringBuilder builder, Collection<ModifiedFile> modifiedFiles) {
        if (modifiedFiles.isEmpty()) {
            return Stream.empty();
        }
        StringBuilder pathClause = new StringBuilder();
        ArrayList arguments = new ArrayList();
        modifiedFiles.forEach(modifiedFile -> {
            pathClause.append(pathClause.length() == 0 ? "(annotation." : "OR (annotation.").append("PATH_MD5").append(" = ?");
            arguments.add(AoInsightAnnotationDao.md5(modifiedFile.getPath()));
            pathClause.append(')');
        });
        builder.append(" AND (").append((CharSequence)pathClause).append(')');
        return arguments.stream();
    }

    private static Stream<String> maybeFilterByReports(StringBuilder builder, Collection<String> reportKeys) {
        if (reportKeys.isEmpty()) {
            return Stream.empty();
        }
        AoInsightAnnotationDao.filterAnnotations(builder, "report", "REPORT_KEY", reportKeys.size());
        return reportKeys.stream();
    }

    private static Stream<Object> maybeFilterBySeverities(StringBuilder builder, Collection<AnnotationSeverity> severities) {
        if (severities.isEmpty()) {
            return Stream.empty();
        }
        AoInsightAnnotationDao.filterAnnotations(builder, "annotation", "SEVERITY_ID", severities.size());
        return severities.stream().map(AnnotationSeverity::getId);
    }

    private static Stream<Object> maybeFilterByTypes(StringBuilder builder, Collection<AnnotationType> types) {
        if (types.isEmpty()) {
            return Stream.empty();
        }
        AoInsightAnnotationDao.filterAnnotations(builder, "annotation", "TYPE_ID", types.size());
        return types.stream().map(AnnotationType::getId);
    }

    private static String md5(String value) {
        return StandardDigests.MD5.apply(value.getBytes(StandardCharsets.UTF_8));
    }
}

