/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.annotation;

import com.atlassian.bitbucket.internal.codeinsights.annotation.FileChanges;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;

public class SourceDiff {
    private final Map<String, FileChanges> fileChanges;
    private final boolean truncated;

    private SourceDiff(Builder builder) {
        this.truncated = builder.truncated;
        this.fileChanges = ImmutableMap.copyOf((Map)builder.fileChanges);
    }

    public Map<String, FileChanges> getFileChanges() {
        return this.fileChanges;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    static class Builder {
        private final Map<String, FileChanges> fileChanges = new HashMap<String, FileChanges>();
        private boolean truncated;

        Builder() {
        }

        public Builder fileChanges(Map<String, FileChanges> fileChanges) {
            this.fileChanges.putAll(fileChanges);
            return this;
        }

        SourceDiff build() {
            return new SourceDiff(this);
        }

        Builder fileChange(String srcPath, FileChanges changes) {
            this.fileChanges.put(srcPath, changes);
            return this;
        }

        Builder truncated(boolean truncated) {
            this.truncated = truncated;
            return this;
        }
    }
}

