/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.annotation;

import com.atlassian.bitbucket.pull.PullRequest;
import java.util.Objects;

public class EffectivePathsCacheKey {
    private final String fromCommit;
    private final long pullRequestId;
    private final int repositoryId;
    private final String toCommit;

    public EffectivePathsCacheKey(PullRequest pullRequest) {
        this.repositoryId = pullRequest.getToRef().getRepository().getId();
        this.pullRequestId = pullRequest.getId();
        this.fromCommit = pullRequest.getFromRef().getLatestCommit();
        this.toCommit = pullRequest.getToRef().getLatestCommit();
    }

    public EffectivePathsCacheKey(int repositoryId, long pullRequestId, String fromCommit, String toCommit) {
        this.repositoryId = repositoryId;
        this.pullRequestId = pullRequestId;
        this.fromCommit = fromCommit;
        this.toCommit = toCommit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EffectivePathsCacheKey other = (EffectivePathsCacheKey)o;
        return this.repositoryId == other.repositoryId && this.pullRequestId == other.pullRequestId && Objects.equals(this.fromCommit, other.fromCommit) && Objects.equals(this.toCommit, other.toCommit);
    }

    public long getPullRequestId() {
        return this.pullRequestId;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public int hashCode() {
        return Objects.hash(this.pullRequestId, this.repositoryId, this.fromCommit, this.toCommit);
    }
}

