/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.codeinsights.annotation;

import com.atlassian.bitbucket.codeinsights.annotation.AnnotationSeverity;
import com.atlassian.bitbucket.codeinsights.annotation.AnnotationType;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public class SearchAnnotationRequest {
    private final Set<String> reportKeys;
    private final String commitId;
    private final Set<String> externalIds;
    private final Set<String> filePaths;
    private final PullRequest pullRequest;
    private final Repository repository;
    private final Set<AnnotationSeverity> severities;
    private final Set<AnnotationType> types;

    private SearchAnnotationRequest(Builder builder) {
        this.reportKeys = ImmutableSet.copyOf((Collection)builder.reportKeys);
        this.commitId = builder.commitId;
        this.externalIds = ImmutableSet.copyOf((Collection)builder.externalIds);
        this.filePaths = ImmutableSet.copyOf((Collection)builder.filePaths);
        this.pullRequest = builder.pullRequest;
        this.repository = builder.repository;
        this.severities = ImmutableSet.copyOf((Collection)builder.severities);
        this.types = ImmutableSet.copyOf((Collection)builder.types);
    }

    @Nonnull
    public Set<String> getReportKeys() {
        return this.reportKeys;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nonnull
    public Set<String> getExternalIds() {
        return this.externalIds;
    }

    @Nonnull
    public Set<String> getFilePaths() {
        return this.filePaths;
    }

    @Nonnull
    public Optional<PullRequest> getPullRequest() {
        return Optional.ofNullable(this.pullRequest);
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public Set<AnnotationSeverity> getSeverities() {
        return this.severities;
    }

    @Nonnull
    public Set<AnnotationType> getTypes() {
        return this.types;
    }

    public static class Builder
    extends BuilderSupport {
        private static final int REPORT_LIMIT = 1000;
        private static final int EXTERNAL_ID_LIMIT = 1000;
        private static final int FILE_PATH_LIMIT = 1000;
        private final String commitId;
        private final Set<String> reportKeys;
        private final Set<String> externalIds;
        private final Set<String> filePaths;
        private final Repository repository;
        private final Set<AnnotationSeverity> severities;
        private final Set<AnnotationType> types;
        private PullRequest pullRequest;

        public Builder(@Nonnull Repository repository, @Nonnull String commitId) {
            this.commitId = Builder.requireNonBlank((String)commitId, (String)"commitId");
            this.repository = Objects.requireNonNull(repository, "repository");
            this.reportKeys = new HashSet<String>();
            this.externalIds = new HashSet<String>();
            this.filePaths = new HashSet<String>();
            this.severities = new HashSet<AnnotationSeverity>();
            this.types = new HashSet<AnnotationType>();
        }

        public Builder(@Nonnull PullRequest pullRequest) {
            this(Objects.requireNonNull(pullRequest, "pullRequest").getToRef().getRepository(), pullRequest.getFromRef().getLatestCommit());
            this.pullRequest = pullRequest;
        }

        @Nonnull
        public SearchAnnotationRequest build() {
            return new SearchAnnotationRequest(this);
        }

        @Nonnull
        public Builder reportKey(@Nonnull String value) {
            Preconditions.checkArgument((this.reportKeys.size() + 1 <= 1000 ? 1 : 0) != 0, (Object)String.format("Cannot filter by more than %s reports", 1000));
            Builder.addIf(Objects::nonNull, this.reportKeys, (Object)value);
            return this;
        }

        @Nonnull
        public Builder reportKeys(@Nonnull Collection<String> values) {
            Preconditions.checkArgument((this.reportKeys.size() + values.size() <= 1000 ? 1 : 0) != 0, (Object)String.format("Cannot filter by more than %s reports", 1000));
            Builder.addIf(Objects::nonNull, this.reportKeys, values);
            return this;
        }

        @Nonnull
        public Builder externalIds(@Nonnull Collection<String> values) {
            Preconditions.checkArgument((this.externalIds.size() + values.size() <= 1000 ? 1 : 0) != 0, (Object)String.format("Cannot filter by more than %s externalIDs", 1000));
            Builder.addIf(Objects::nonNull, this.externalIds, values);
            return this;
        }

        @Nonnull
        public Builder externalId(@Nonnull String value) {
            Preconditions.checkArgument((this.externalIds.size() + 1 <= 1000 ? 1 : 0) != 0, (Object)String.format("Cannot filter by more than %s externalIDs", 1000));
            Builder.addIf(Objects::nonNull, this.externalIds, (Object)value);
            return this;
        }

        @Nonnull
        public Builder path(@Nonnull String value) {
            Preconditions.checkArgument((this.filePaths.size() + 1 <= 1000 ? 1 : 0) != 0, (Object)String.format("Cannot filter by more than %s paths", 1000));
            Builder.addIf(Objects::nonNull, this.filePaths, (Object)value);
            return this;
        }

        @Nonnull
        public Builder paths(@Nonnull Collection<String> values) {
            Preconditions.checkArgument((this.filePaths.size() + values.size() <= 1000 ? 1 : 0) != 0, (Object)String.format("Cannot filter by more than 1%s000 paths", 1000));
            Builder.addIf(Objects::nonNull, this.filePaths, values);
            return this;
        }

        @Nonnull
        public Builder severities(@Nonnull Iterable<AnnotationSeverity> values) {
            Builder.addIf(Objects::nonNull, this.severities, values);
            return this;
        }

        @Nonnull
        public Builder severity(@Nonnull AnnotationSeverity value) {
            Builder.addIf(Objects::nonNull, this.severities, (Object)((Object)value));
            return this;
        }

        @Nonnull
        public Builder types(Iterable<AnnotationType> values) {
            Builder.addIf(Objects::nonNull, this.types, values);
            return this;
        }
    }
}

