/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.commit.LastModifiedContext;
import com.atlassian.bitbucket.commit.LastModifiedRequest;
import com.atlassian.bitbucket.scm.AbstractCommitCommandParameters;
import javax.annotation.Nonnull;

public class LastModifiedCommandParameters
extends AbstractCommitCommandParameters {
    private final int maxMessageLength;

    private LastModifiedCommandParameters(Builder builder) {
        super(builder);
        this.maxMessageLength = builder.maxMessageLength;
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    @Nonnull
    public LastModifiedContext toContext() {
        return new LastModifiedContext.Builder(this.getCommitId()).path(this.getPath()).build();
    }

    public static class Builder
    extends AbstractCommitCommandParameters.AbstractCommitParametersBuilder<Builder> {
        private int maxMessageLength;

        public Builder(@Nonnull String commitId) {
            this.commitId(commitId);
            this.maxMessageLength = -1;
        }

        public Builder(@Nonnull LastModifiedRequest request) {
            super(request);
            this.maxMessageLength = request.getMaxMessageLength();
        }

        @Nonnull
        public LastModifiedCommandParameters build() {
            return new LastModifiedCommandParameters(this);
        }

        @Override
        @Nonnull
        public Builder commitId(@Nonnull String value) {
            return (Builder)super.commitId(LastModifiedCommandParameters.requireNonBlank(value, "commitId"));
        }

        @Nonnull
        public Builder maxMessageLength(int value) {
            this.maxMessageLength = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

