/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.mirror;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.mirror.RepositoryMirrorEvent;
import com.atlassian.bitbucket.repository.Repository;
import java.util.Objects;
import javax.annotation.Nonnull;

public class AbstractRepositoryMirrorEvent
extends ApplicationEvent
implements RepositoryMirrorEvent {
    private final String mirrorServerId;
    private final String mirrorServerName;
    private final Repository repository;

    protected AbstractRepositoryMirrorEvent(Builder builder) {
        super(builder.source);
        this.mirrorServerId = builder.mirrorServerId;
        this.mirrorServerName = builder.mirrorServerName;
        this.repository = builder.repository;
    }

    @Override
    @Nonnull
    public String getMirrorServerId() {
        return this.mirrorServerId;
    }

    @Override
    @Nonnull
    public String getMirrorServerName() {
        return this.mirrorServerName;
    }

    @Override
    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    protected static abstract class Builder<B extends Builder, T extends AbstractRepositoryMirrorEvent> {
        private String mirrorServerId;
        private String mirrorServerName;
        private Repository repository;
        private Object source;

        protected Builder() {
        }

        @Nonnull
        public abstract T build();

        @Nonnull
        public B mirrorServerId(@Nonnull String value) {
            this.mirrorServerId = Objects.requireNonNull(value, "mirrorServerId");
            return this.self();
        }

        @Nonnull
        public B mirrorServerName(@Nonnull String value) {
            this.mirrorServerName = Objects.requireNonNull(value, "mirrorServerName");
            return this.self();
        }

        @Nonnull
        public B repository(@Nonnull Repository value) {
            this.repository = Objects.requireNonNull(value, "repository");
            return this.self();
        }

        @Nonnull
        public B source(@Nonnull Object value) {
            this.source = Objects.requireNonNull(value, "source");
            return this.self();
        }

        protected B self() {
            return (B)this;
        }

        protected void validate() {
            if (this.mirrorServerId == null) {
                throw new IllegalStateException("mirrorServerId is required");
            }
            if (this.mirrorServerName == null) {
                throw new IllegalStateException("mirrorServerName is required");
            }
            if (this.repository == null) {
                throw new IllegalStateException("repository is required");
            }
            if (this.source == null) {
                throw new IllegalStateException("source is required");
            }
        }
    }
}

