package com.atlassian.bitbucket.user;

import javax.annotation.Nonnull;

/**
 * Represents a registered service user.
 * <p>
 * Service users are not backed by a user from a Crowd directory and are not able to authenticate via the UI or
 * REST. Service users can be used to programmatically perform tasks which require an associated user and do not
 * count towards the licensed user count.
 *
 * @see UserAdminService#createServiceUser(ServiceUserCreateRequest)
 */
public interface ServiceUser extends ApplicationUser {

    String DEFAULT_LABEL = "bot";

    /**
     * @return a label to help identify the type of ServiceUser
     */
    @Nonnull
    String getLabel();
}
