package com.atlassian.bitbucket.scm.bulk;

import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.util.AbstractSummary;

import javax.annotation.Nonnull;

/**
 * Contains a summary about the traversal which just ended.
 * <p>
 * This is currently just a placeholder and contains no interesting information.
 *
 * @see BulkTraversalCallback#onEnd(BulkTraversalSummary)
 * @since 5.11
 */
public class BulkTraversalSummary extends AbstractSummary {

    private BulkTraversalSummary(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder, BulkTraversalSummary> {

        public Builder(@Nonnull AbstractSummary summary) {
            super(summary);
        }

        public Builder(@Nonnull CommandResult result) {
            super(result);
        }

        @Nonnull
        @Override
        public BulkTraversalSummary build() {
            return new BulkTraversalSummary(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
