package com.atlassian.bitbucket.scm;

import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nonnull;

public class TypeCommandParameters extends AbstractCommitCommandParameters {

    private TypeCommandParameters(Builder builder) {
        super(builder);

        if (StringUtils.isBlank(getCommitId())) {
            throw new IllegalStateException(
                    "A commit ID must provided when querying for a content tree node's type");
        }
    }

    public static class Builder extends AbstractCommitParametersBuilder<Builder> {

        public Builder() {
        }

        @Nonnull
        public TypeCommandParameters build() {
            return new TypeCommandParameters(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
