package com.atlassian.bitbucket.request;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Callback provided to callers of {@link RequestManager#doAsRequest(RequestCallback, RequestInfoProvider)}. The callback
 * provides all information in the {@link RequestInfoProvider} plus a generated requestId.
 */
public interface RequestCallback<T, E extends Exception> {
    
    /**
     * Callback method that is called by {@link RequestManager#doAsRequest(RequestCallback, RequestInfoProvider)}
     * 
     * @param requestContext information about the current request, including a generated request id.
     * @return the value that should be returned by {@link RequestManager#doAsRequest(RequestCallback, RequestInfoProvider)}
     * @throws E if the callback fails
     */
    @Nullable
    T withRequest(@Nonnull RequestContext requestContext) throws E;
}
