package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RepositoryRef;

/**
 * A {@link Ref ref} involved in a {@link PullRequest pull request}, linking to the {@link #getRepository() repository}
 * the ref is in. This allows {@link PullRequest#isCrossRepository() cross-repository} pull requests.
 *
 * @see PullRequest#getFromRef()
 * @see PullRequest#getToRef()
 */
public interface PullRequestRef extends RepositoryRef {
}
