package com.atlassian.bitbucket.pull;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * @since 4.10
 */
public class PullRequestMergeResult {

    private final PullRequestMergeOutcome outcome;

    private PullRequestMergeResult(@Nonnull Builder builder) {
        outcome = builder.outcome;
    }

    @Nonnull
    public PullRequestMergeOutcome getOutcome() {
        return outcome;
    }

    public static class Builder {

        private final PullRequestMergeOutcome outcome;

        public Builder(@Nonnull PullRequestMergeOutcome value) {
            outcome = requireNonNull(value, "outcome");
        }

        @Nonnull
        public PullRequestMergeResult build() {
            return new PullRequestMergeResult(this);
        }
    }
}
