package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.FeatureDisabledException;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.server.StandardFeature;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Thrown when a user, or a plugin, attempts to delete a pull request when {@link StandardFeature#PULL_REQUEST_DELETION
 * the feature} has been disabled.
 *
 * @see StandardFeature#PULL_REQUEST_DELETION
 * @since 5.1
 */
public class PullRequestDeletionDisabledException extends FeatureDisabledException {

    private final PullRequest pullRequest;

    public PullRequestDeletionDisabledException(@Nonnull KeyedMessage message, @Nonnull PullRequest pullRequest) {
        super(message);

        this.pullRequest = requireNonNull(pullRequest, "pullRequest");
    }

    @Nonnull
    public PullRequest getPullRequest() {
        return pullRequest;
    }
}
