package com.atlassian.bitbucket.hook.script;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Base event for {@link HookScript HookScripts}.
 *
 * @since 6.2
 */
@TransactionAware
public abstract class HookScriptEvent extends ApplicationEvent {

    private final HookScript hookScript;

    protected HookScriptEvent(@Nonnull Object source, @Nonnull HookScript hookScript) {
        super(source);
        this.hookScript = requireNonNull(hookScript, "hookScript");
    }

    @Nonnull
    public HookScript getHookScript() {
        return hookScript;
    }
}
