package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;

import javax.annotation.Nonnull;

/**
 * Request that is provided to {@code repository-hook} plugin modules when a {@link PullRequest} is merged.
 *
 * @see StandardRepositoryHookTrigger#PULL_REQUEST_MERGE
 * @since 5.0
 */
public interface PullRequestMergeHookRequest extends MergeHookRequest {

    /**
     * @return the pull request's {@link PullRequest#getFromRef() from-ref}
     */
    @Nonnull
    @Override
    PullRequestRef getFromRef();

    /**
     * @return the pull request being merged
     */
    @Nonnull
    PullRequest getPullRequest();

    /**
     * @return the pull request's {@link PullRequest#getToRef() to-ref}
     */
    @Nonnull
    @Override
    PullRequestRef getToRef();
}
