package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event raised when a {@link PullRequestParticipant participant} updates its status
 * on a {@link PullRequest pull request} to {@link PullRequestParticipantStatus#APPROVED}
 */
@AsynchronousPreferred
@EventName("stash.pullrequest.approved")
public class PullRequestParticipantApprovedEvent extends PullRequestParticipantReviewedEvent {

    public PullRequestParticipantApprovedEvent(@Nonnull Object source,
                                               @Nonnull PullRequest pullRequest,
                                               @Nonnull PullRequestParticipant participant,
                                               @Nonnull PullRequestParticipantStatus previous) {
        super(source, pullRequest, participant, previous);
    }
}
