package com.atlassian.bitbucket.event.permission;

import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;

/**
 * This event is fired when a user or group has their global permission modified.
 * <p>
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 */
public class GlobalPermissionModifiedEvent extends AbstractGlobalPermissionModificationEvent implements PermissionModifiedEvent {

    public GlobalPermissionModifiedEvent(Object source, Permission oldValue, Permission newValue, String affectedGroup, ApplicationUser affectedUser) {
        super(source, oldValue, newValue, affectedGroup, affectedUser);
    }

}
