package com.atlassian.bitbucket.event.backup;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Raised when the system starts creating a new backup.
 * <p>
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 */
@AsynchronousPreferred
@EventName("stash.backup.started")
public class BackupStartedEvent extends BackupEvent {

    public BackupStartedEvent(@Nonnull Object source) {
        super(source);
    }
}
